/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.OrmLiteDao;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class OrmLiteDaoProcessor
implements DecoratingElementProcessor {
    private static final String CONNECTION_SOURCE_FIELD_NAME = "connectionSource_";
    private TargetAnnotationHelper helper;

    public OrmLiteDaoProcessor(ProcessingEnvironment processingEnv) {
        this.helper = new TargetAnnotationHelper(processingEnv, this.getTarget());
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return OrmLiteDao.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        JFieldVar connectionSourceRef;
        EBeansHolder.Classes classes = holder.classes();
        String fieldName = element.getSimpleName().toString();
        TypeMirror modelObjectTypeMirror = (TypeMirror)this.helper.extractAnnotationParameter(element, "model");
        TypeMirror databaseHelperTypeMirror = (TypeMirror)this.helper.extractAnnotationParameter(element, "helper");
        boolean connectionSourceInjected = holder.generatedClass.fields().containsKey(CONNECTION_SOURCE_FIELD_NAME);
        JBlock initBody = holder.init.body();
        if (connectionSourceInjected) {
            connectionSourceRef = holder.generatedClass.fields().get(CONNECTION_SOURCE_FIELD_NAME);
        } else {
            connectionSourceRef = holder.generatedClass.field(4, classes.CONNECTION_SOURCE, CONNECTION_SOURCE_FIELD_NAME);
            JExpression dbHelperClass = holder.refClass(((Object)databaseHelperTypeMirror).toString()).dotclass();
            initBody.assign(connectionSourceRef, classes.OPEN_HELPER_MANAGER.staticInvoke("getHelper").arg(holder.contextRef).arg(dbHelperClass).invoke("getConnectionSource"));
        }
        JTryBlock tryBlock = initBody._try();
        JExpression modelClass = holder.refClass(((Object)modelObjectTypeMirror).toString()).dotclass();
        tryBlock.body().assign(JExpr.ref(fieldName), classes.DAO_MANAGER.staticInvoke("createDao").arg(connectionSourceRef).arg(modelClass));
        JCatchBlock catchBlock = tryBlock._catch(classes.SQL_EXCEPTION);
        JVar exception = catchBlock.param("e");
        catchBlock.body().staticInvoke(classes.LOG, "e").arg(holder.generatedClass.name()).arg("Could not create DAO").arg(exception);
    }
}

