/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.SystemService;
import com.googlecode.androidannotations.model.AndroidSystemServices;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class SystemServiceProcessor
implements DecoratingElementProcessor {
    private final AndroidSystemServices androidSystemServices;

    public SystemServiceProcessor(AndroidSystemServices androidSystemServices) {
        this.androidSystemServices = androidSystemServices;
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return SystemService.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror serviceType = element.asType();
        String fieldTypeQualifiedName = ((Object)serviceType).toString();
        JFieldRef serviceRef = this.androidSystemServices.getServiceConstant(serviceType, holder);
        JBlock methodBody = holder.init.body();
        methodBody.assign(JExpr.ref(fieldName), JExpr.cast(holder.refClass(fieldTypeQualifiedName), holder.contextRef.invoke("getSystemService").arg(serviceRef)));
    }
}

