/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing.rest;

import com.googlecode.androidannotations.annotations.rest.Rest;
import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.processing.GeneratingElementProcessor;
import com.googlecode.androidannotations.processing.rest.RestImplementationHolder;
import com.googlecode.androidannotations.processing.rest.RestImplementationsHolder;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public class RestProcessor
implements GeneratingElementProcessor {
    private final RestImplementationsHolder restImplementationHolder;
    private AnnotationHelper annotationHelper;

    public RestProcessor(ProcessingEnvironment processingEnv, RestImplementationsHolder restImplementationHolder) {
        this.annotationHelper = new AnnotationHelper(processingEnv);
        this.restImplementationHolder = restImplementationHolder;
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Rest.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeansHolder eBeansHolder) throws Exception {
        VariableElement firstParameter;
        List<? extends VariableElement> parameters;
        RestImplementationHolder holder = this.restImplementationHolder.create(element);
        TypeElement typeElement = (TypeElement)element;
        String interfaceName = typeElement.getQualifiedName().toString();
        String implementationName = interfaceName + "_";
        holder.restImplementationClass = codeModel._class(1, implementationName, ClassType.CLASS);
        eBeansHolder.create(element, this.getTarget(), holder.restImplementationClass);
        JClass interfaceClass = eBeansHolder.refClass(interfaceName);
        holder.restImplementationClass._implements(interfaceClass);
        JClass restTemplateClass = eBeansHolder.refClass("org.springframework.web.client.RestTemplate");
        holder.restTemplateField = holder.restImplementationClass.field(4, restTemplateClass, "restTemplate");
        JClass stringClass = eBeansHolder.refClass(CanonicalNameConstants.STRING);
        holder.rootUrlField = holder.restImplementationClass.field(4, stringClass, "rootUrl");
        JMethod constructor = holder.restImplementationClass.constructor(1);
        JBlock constructorBody = constructor.body();
        constructorBody.assign(holder.restTemplateField, JExpr._new(restTemplateClass));
        List<DeclaredType> converters = this.annotationHelper.extractAnnotationClassArrayParameter(element, this.getTarget(), "converters");
        for (DeclaredType converterType : converters) {
            JClass converterClass = eBeansHolder.refClass(converterType.toString());
            constructorBody.add(JExpr.invoke((JExpression)holder.restTemplateField, "getMessageConverters").invoke("add").arg(JExpr._new(converterClass)));
        }
        constructorBody.assign(holder.rootUrlField, JExpr.lit(typeElement.getAnnotation(Rest.class).rootUrl()));
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(enclosedElements);
        for (ExecutableElement method : methods) {
            if (method.getParameters().size() != 0 || !((Object)method.getReturnType()).toString().equals("org.springframework.web.client.RestTemplate")) continue;
            String methodName = method.getSimpleName().toString();
            JMethod getRestTemplateMethod = holder.restImplementationClass.method(1, restTemplateClass, methodName);
            getRestTemplateMethod.annotate(Override.class);
            getRestTemplateMethod.body()._return(holder.restTemplateField);
            break;
        }
        for (ExecutableElement method : methods) {
            parameters = method.getParameters();
            if (parameters.size() != 1 || method.getReturnType().getKind() != TypeKind.VOID || !((Object)(firstParameter = parameters.get(0)).asType()).toString().equals("org.springframework.web.client.RestTemplate")) continue;
            String methodName = method.getSimpleName().toString();
            JMethod setRestTemplateMethod = holder.restImplementationClass.method(1, codeModel.VOID, methodName);
            setRestTemplateMethod.annotate(Override.class);
            JVar restTemplateSetterParam = setRestTemplateMethod.param(restTemplateClass, firstParameter.getSimpleName().toString());
            setRestTemplateMethod.body().assign(JExpr._this().ref(holder.restTemplateField), restTemplateSetterParam);
            break;
        }
        for (ExecutableElement method : methods) {
            parameters = method.getParameters();
            if (parameters.size() != 1 || method.getReturnType().getKind() != TypeKind.VOID || !((Object)(firstParameter = parameters.get(0)).asType()).toString().equals(CanonicalNameConstants.STRING) || !method.getSimpleName().toString().equals("setRootUrl")) continue;
            JMethod setRootUrlMethod = holder.restImplementationClass.method(1, codeModel.VOID, method.getSimpleName().toString());
            setRootUrlMethod.annotate(Override.class);
            JVar rootUrlSetterParam = setRootUrlMethod.param(stringClass, firstParameter.getSimpleName().toString());
            setRootUrlMethod.body().assign(JExpr._this().ref(holder.rootUrlField), rootUrlSetterParam);
            break;
        }
    }
}

