/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.RunningLengthWord;

final class IntIteratorImpl
implements IntIterator {
    private final EWAHIterator ewahIter;
    private final long[] ewahBuffer;
    private int position;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    IntIteratorImpl(EWAHIterator ewahIter) {
        this.ewahIter = ewahIter;
        this.ewahBuffer = ewahIter.buffer();
        this.hasNext = this.moveToNext();
    }

    public boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            long t = this.word & -this.word;
            answer = this.literalPosition + Long.bitCount(t - 1L);
            this.word ^= t;
        }
        this.hasNext = this.moveToNext();
        return answer;
    }

    private void setRunningLengthWord(RunningLengthWord rlw) {
        this.runningLength = 64 * (int)rlw.getRunningLength() + this.position;
        if (!rlw.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.literalWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0L && this.wordPosition < this.wordLength) {
            this.word = this.ewahBuffer[this.wordPosition++];
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0L;
    }
}

