/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.BeanMappingExecutor;
import com.agapple.mapping.core.BeanMappingParam;
import com.agapple.mapping.core.config.BeanMappingConfigHelper;
import com.agapple.mapping.core.config.BeanMappingEnvironment;
import com.agapple.mapping.core.config.BeanMappingObject;
import java.util.HashMap;
import java.util.Map;

public class BeanMap {
    private BeanMappingObject describeConfig;
    private BeanMappingObject populateConfig;

    BeanMap(BeanMappingObject describeConfig, BeanMappingObject populateConfig) {
        this.describeConfig = describeConfig;
        this.populateConfig = populateConfig;
    }

    public static BeanMap create(Class srcClass) {
        BeanMappingObject describeConfig = BeanMappingConfigHelper.getInstance().getBeanMapObject(srcClass, Map.class, true);
        BeanMappingObject populateConfig = BeanMappingConfigHelper.getInstance().getBeanMapObject(Map.class, srcClass, true);
        return new BeanMap(describeConfig, populateConfig);
    }

    public Map describe(Object src) throws BeanMappingException {
        HashMap result = new HashMap();
        BeanMappingParam param = new BeanMappingParam();
        param.setSrcRef(src);
        param.setTargetRef(result);
        param.setConfig(this.describeConfig);
        param.setProcesses(BeanMappingEnvironment.getBeanMapVps());
        BeanMappingExecutor.execute(param);
        return result;
    }

    public void populate(Object target, Map properties) throws BeanMappingException {
        BeanMappingParam param = new BeanMappingParam();
        param.setSrcRef(properties);
        param.setTargetRef(target);
        param.setConfig(this.populateConfig);
        param.setProcesses(BeanMappingEnvironment.getBeanMapVps());
        BeanMappingExecutor.execute(param);
    }
}

