/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.BeanMappingExecutor;
import com.agapple.mapping.core.BeanMappingParam;
import com.agapple.mapping.core.builder.BeanMappingBuilder;
import com.agapple.mapping.core.config.BeanMappingConfigHelper;
import com.agapple.mapping.core.config.BeanMappingEnvironment;
import com.agapple.mapping.core.config.BeanMappingObject;
import com.agapple.mapping.process.script.ScriptHelper;

public class BeanMapping {
    private BeanMappingObject config;

    BeanMapping(BeanMappingObject config) {
        this.config = config;
    }

    public BeanMapping(BeanMappingBuilder builder) {
        this.config = builder.get();
    }

    public static BeanMapping create(Class srcClass, Class targetClass) {
        BeanMappingObject config = BeanMappingConfigHelper.getInstance().getBeanMappingObject(srcClass, targetClass);
        if (config == null) {
            throw new BeanMappingException("can not found mapping config for srcClass[" + srcClass.toString() + "] targetClass[" + targetClass + "]");
        }
        return new BeanMapping(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapping(Object src, Object target) throws BeanMappingException {
        BeanMappingParam param = new BeanMappingParam();
        param.setSrcRef(src);
        param.setTargetRef(target);
        param.setConfig(this.config);
        param.setProcesses(BeanMappingEnvironment.getBeanMappingVps());
        try {
            BeanMappingExecutor.execute(param);
        }
        finally {
            ScriptHelper.getInstance().getScriptExecutor().disposeFunctions();
        }
    }
}

