/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.config.parse;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.config.BeanMappingBehavior;
import com.agapple.mapping.core.config.BeanMappingConfigHelper;
import com.agapple.mapping.core.config.BeanMappingField;
import com.agapple.mapping.core.config.BeanMappingFieldAttributes;
import com.agapple.mapping.core.config.BeanMappingObject;
import com.agapple.mapping.core.config.parse.BeanMappingBehaviorParse;
import com.agapple.mapping.core.config.parse.BeanMappingParse;
import com.agapple.mapping.core.config.parse.ClassAliasParse;
import com.agapple.mapping.core.config.parse.ConvertorParse;
import com.agapple.mapping.core.config.parse.FunctionClassParse;
import com.agapple.mapping.core.helper.ReflectionHelper;
import com.agapple.mapping.core.helper.XmlHelper;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeanMappingParser {
    private static final String MAPPING_SCHEMA = "META-INF/mapping.xsd";

    public static List<BeanMappingObject> parseMapping(InputStream in) throws BeanMappingException {
        List<BeanMappingObject> result = BeanMappingParser.parseMappingObject(in);
        ArrayList<BeanMappingObject> reseverResult = new ArrayList<BeanMappingObject>(result.size());
        for (BeanMappingObject object : result) {
            BeanMappingObject reverseObject;
            if (!object.isReversable() || (reverseObject = BeanMappingParser.reverse(object)) == null) continue;
            reseverResult.add(reverseObject);
        }
        result.addAll(reseverResult);
        return result;
    }

    public static List<BeanMappingObject> parseMapping(Class src, Class target) throws BeanMappingException {
        BeanMappingObject reverseObject;
        ArrayList<BeanMappingObject> result = new ArrayList<BeanMappingObject>(2);
        PropertyDescriptor[] targetPds = ReflectionHelper.getPropertyDescriptors(target);
        PropertyDescriptor[] srcPds = ReflectionHelper.getPropertyDescriptors(src);
        BeanMappingObject object = new BeanMappingObject();
        object.setSrcClass(src);
        object.setTargetClass(target);
        object.setBatch(true);
        BeanMappingBehavior globalBehavior = BeanMappingConfigHelper.getInstance().getGlobalBehavior();
        ArrayList<BeanMappingField> fields = new ArrayList<BeanMappingField>();
        for (PropertyDescriptor targetPd : targetPds) {
            String property = targetPd.getName();
            PropertyDescriptor srcPd = BeanMappingParser.getMatchPropertyDescriptor(srcPds, property);
            if (srcPd == null || targetPd.getWriteMethod() == null || srcPd.getReadMethod() == null) continue;
            BeanMappingField field = new BeanMappingField();
            BeanMappingFieldAttributes srcFieldAttribute = new BeanMappingFieldAttributes();
            srcFieldAttribute.setName(property);
            srcFieldAttribute.setClazz(srcPd.getPropertyType());
            BeanMappingFieldAttributes targetFieldAttribute = new BeanMappingFieldAttributes();
            targetFieldAttribute.setName(property);
            targetFieldAttribute.setClazz(targetPd.getPropertyType());
            field.setSrcField(srcFieldAttribute);
            field.setTargetField(targetFieldAttribute);
            field.setBehavior(globalBehavior);
            fields.add(field);
        }
        object.setBeanFields(fields);
        object.setBehavior(globalBehavior);
        result.add(object);
        if (object.isReversable() && (reverseObject = BeanMappingParser.reverse(object)) != null) {
            result.add(reverseObject);
        }
        return result;
    }

    public static List<BeanMappingObject> parseMapMapping(Class src) throws BeanMappingException {
        BeanMappingObject reverseObject;
        ArrayList<BeanMappingObject> result = new ArrayList<BeanMappingObject>(2);
        PropertyDescriptor[] targetPds = ReflectionHelper.getPropertyDescriptors(src);
        BeanMappingObject object = new BeanMappingObject();
        object.setSrcClass(src);
        object.setTargetClass(Map.class);
        object.setBatch(true);
        ArrayList<BeanMappingField> fields = new ArrayList<BeanMappingField>();
        BeanMappingBehavior globalBehavior = BeanMappingConfigHelper.getInstance().getGlobalBehavior();
        for (PropertyDescriptor targetPd : targetPds) {
            if (targetPd.getWriteMethod() == null || targetPd.getReadMethod() == null) continue;
            BeanMappingField field = new BeanMappingField();
            BeanMappingFieldAttributes srcFieldAttribute = new BeanMappingFieldAttributes();
            srcFieldAttribute.setName(targetPd.getName());
            srcFieldAttribute.setClazz(targetPd.getPropertyType());
            BeanMappingFieldAttributes targetFieldAttribute = new BeanMappingFieldAttributes();
            targetFieldAttribute.setName(targetPd.getName());
            targetFieldAttribute.setClazz(targetPd.getPropertyType());
            field.setSrcField(srcFieldAttribute);
            field.setTargetField(targetFieldAttribute);
            field.setBehavior(globalBehavior);
            fields.add(field);
        }
        object.setBeanFields(fields);
        object.setBehavior(globalBehavior);
        result.add(object);
        if (object.isReversable() && (reverseObject = BeanMappingParser.reverse(object)) != null) {
            result.add(reverseObject);
        }
        return result;
    }

    private static BeanMappingObject reverse(BeanMappingObject object) {
        BeanMappingObject newObject = new BeanMappingObject();
        newObject.setSrcClass(object.getTargetClass());
        newObject.setTargetClass(object.getSrcClass());
        newObject.setReversable(object.isReversable());
        newObject.setBatch(object.isBatch());
        newObject.setSrcKey(object.getSrcKey());
        newObject.setTargetKey(object.getTargetKey());
        newObject.setBehavior(object.getBehavior());
        List<BeanMappingField> fields = newObject.getBeanFields();
        for (BeanMappingField field : object.getBeanFields()) {
            BeanMappingField newField = new BeanMappingField();
            BeanMappingFieldAttributes srcFieldAttribute = new BeanMappingFieldAttributes();
            srcFieldAttribute.setName(field.getTargetField().getName());
            srcFieldAttribute.setClazz(field.getTargetField().getClazz());
            BeanMappingFieldAttributes targetFieldAttribute = new BeanMappingFieldAttributes();
            targetFieldAttribute.setName(field.getSrcField().getName());
            targetFieldAttribute.setClazz(field.getSrcField().getClazz());
            newField.setSrcField(srcFieldAttribute);
            newField.setTargetField(targetFieldAttribute);
            newField.setDefaultValue(field.getDefaultValue());
            newField.setMapping(field.isMapping());
            newField.setBehavior(field.getBehavior());
            if (StringUtils.isNotEmpty((String)field.getConvertor()) || StringUtils.isNotEmpty((String)field.getScript())) {
                object.setReversable(false);
                return null;
            }
            fields.add(newField);
        }
        return newObject;
    }

    private static PropertyDescriptor getMatchPropertyDescriptor(PropertyDescriptor[] srcPds, String property) {
        for (PropertyDescriptor srcPd : srcPds) {
            if (!srcPd.getName().equals(property)) continue;
            return srcPd;
        }
        return null;
    }

    private static List<BeanMappingObject> parseMappingObject(InputStream in) {
        Document doc = XmlHelper.createDocument(in, Thread.currentThread().getContextClassLoader().getResourceAsStream(MAPPING_SCHEMA));
        Element root = doc.getDocumentElement();
        NodeList globalNodeList = root.getElementsByTagName("global-configurations");
        if (globalNodeList.getLength() > 1) {
            throw new BeanMappingException("global-configurations is exceed one node!");
        }
        BeanMappingBehavior globalBehavior = BeanMappingConfigHelper.getInstance().getGlobalBehavior();
        if (globalNodeList.getLength() == 1) {
            globalBehavior = BeanMappingBehaviorParse.parse(globalNodeList.item(0), globalBehavior);
            BeanMappingConfigHelper.getInstance().setGlobalBehavior(globalBehavior);
        }
        NodeList classAliasNodeList = root.getElementsByTagName("class-alias-configurations");
        for (int i = 0; i < classAliasNodeList.getLength(); ++i) {
            ClassAliasParse.parseAndRegister(classAliasNodeList.item(i));
        }
        NodeList convetorNodeList = root.getElementsByTagName("convetors-configurations");
        for (int i = 0; i < convetorNodeList.getLength(); ++i) {
            ConvertorParse.parseAndRegister(convetorNodeList.item(i));
        }
        NodeList functionClassNodeList = root.getElementsByTagName("function-class-configurations");
        for (int i = 0; i < functionClassNodeList.getLength(); ++i) {
            FunctionClassParse.parseAndRegister(functionClassNodeList.item(i));
        }
        NodeList nodeList = root.getElementsByTagName("bean-mapping");
        ArrayList<BeanMappingObject> mappings = new ArrayList<BeanMappingObject>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            BeanMappingObject config = BeanMappingParse.parse(nodeList.item(i), globalBehavior);
            mappings.add(config);
        }
        return mappings;
    }
}

