/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.introspect;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.introspect.AbstractExecutor;
import com.agapple.mapping.core.introspect.Introspector;
import com.agapple.mapping.core.introspect.SetExecutor;
import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class FastPropertySetExecutor
extends AbstractExecutor
implements SetExecutor {
    private FastMethod method;

    public FastPropertySetExecutor(Introspector is, Class<?> clazz, String identifier, Class arg) {
        super(clazz, identifier);
        this.method = FastPropertySetExecutor.discover(is, clazz, identifier, arg);
    }

    @Override
    public Object invoke(Object key, Object value) throws BeanMappingException {
        Object[] pargs = new Object[]{value};
        try {
            this.method.invoke(key, pargs);
            return value;
        }
        catch (Exception e) {
            throw new BeanMappingException(e);
        }
    }

    @Override
    public boolean isAlive() {
        return this.method != null;
    }

    public static FastMethod discover(Introspector is, Class<?> clazz, String property, Class arg) {
        String prefix = "set";
        int start = prefix.length();
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(property);
        char c = sb.charAt(start);
        sb.setCharAt(start, Character.toUpperCase(c));
        if (arg == null) {
            Method method = is.getJavaMethod(clazz, sb.toString());
            if (method == null) {
                sb.setCharAt(start, Character.toLowerCase(c));
                method = is.getJavaMethod(clazz, sb.toString());
            }
            if (method != null) {
                FastClass fc = is.getFastClass(clazz);
                return fc.getMethod(method);
            }
            return null;
        }
        FastMethod fastMethod = is.getFastMethod(clazz, sb.toString(), arg);
        if (fastMethod == null) {
            sb.setCharAt(start, Character.toLowerCase(c));
            fastMethod = is.getFastMethod(clazz, sb.toString(), arg);
        }
        return fastMethod;
    }

    public FastMethod getMethod() {
        return this.method;
    }
}

