/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.introspect;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.introspect.AbstractExecutor;
import com.agapple.mapping.core.introspect.Introspector;
import com.agapple.mapping.core.introspect.SetExecutor;
import java.lang.reflect.Field;

public class FieldSetExecutor
extends AbstractExecutor
implements SetExecutor {
    private Field field;

    protected FieldSetExecutor(Introspector is, Class<?> clazz, String identifier, Class arg) {
        super(clazz, identifier);
        this.field = FieldSetExecutor.discover(is, clazz, identifier, arg);
    }

    @Override
    public boolean isAlive() {
        return this.field != null;
    }

    @Override
    public Object invoke(Object obj, Object value) throws BeanMappingException {
        try {
            this.field.set(obj, value);
            return value;
        }
        catch (Exception e) {
            throw new BeanMappingException("field invoke error!", e);
        }
    }

    public static Field discover(Introspector is, Class<?> clazz, String property, Class arg) {
        Field field = is.getField(clazz, property);
        if (field != null) {
            if (field.getType() != arg) {
                return null;
            }
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    public Field getField() {
        return this.field;
    }
}

