/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.introspect;

import com.agapple.mapping.core.BeanMappingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class Introspector {
    private Map<String, FastClass> fastClassCache = new ConcurrentHashMap<String, FastClass>();
    private Map<String, FastMethod> fastMethodCache = new ConcurrentHashMap<String, FastMethod>();
    private Map<String, Class> classCache = new ConcurrentHashMap<String, Class>();
    private Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();
    private Map<String, Method[]> allMethodCache = new ConcurrentHashMap<String, Method[]>();
    private Map<String, Field> fieldCache = new ConcurrentHashMap<String, Field>();

    public FastMethod getFastMethod(Class<?> clazz, String methodName) {
        return this.getFastMethod(clazz, methodName, new Class[0]);
    }

    public FastMethod getFastMethod(Class<?> clazz, String methodName, Object ... parameter) {
        if (parameter == null) {
            return this.getFastMethod(clazz, methodName);
        }
        Class[] types = new Class[parameter.length];
        for (int i = 0; i < parameter.length; ++i) {
            types[i] = parameter.getClass();
        }
        return this.getFastMethod(clazz, methodName, types);
    }

    public FastMethod getFastMethod(Class<?> clazz, String methodName, Class ... parameterTypes) {
        String clazzName = clazz.getName();
        String methodKey = this.buildMethodKey(clazzName, methodName, parameterTypes);
        FastMethod method = this.fastMethodCache.get(methodKey);
        if (null == method) {
            this.getFastClass(clazz);
            return this.fastMethodCache.get(methodKey);
        }
        return method;
    }

    public Method getJavaMethod(Class<?> clazz, String methodName, Class ... parameterTypes) {
        String clazzName = clazz.getName();
        String methodKey = this.buildMethodKey(clazzName, methodName, parameterTypes);
        Method method = this.methodCache.get(methodKey);
        if (null == method) {
            this.getFastClass(clazz);
            return this.methodCache.get(methodKey);
        }
        return method;
    }

    public Method getJavaMethod(Class<?> clazz, String methodName) {
        String className = clazz.getName();
        Method[] methods = this.allMethodCache.get(className);
        if (methods == null) {
            this.initJavaClassCache(clazz);
            methods = this.allMethodCache.get(className);
        }
        if (methods == null) {
            return null;
        }
        for (Method method : methods) {
            if (!methodName.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    public Method[] getJavaMethods(Class<?> clazz) {
        Method[] methods = this.allMethodCache.get(clazz.getName());
        if (methods == null) {
            this.initJavaClassCache(clazz);
            return this.allMethodCache.get(clazz.getName());
        }
        return methods;
    }

    public Field getField(Class<?> clazz, String fieldName) {
        Field field = this.fieldCache.get(fieldName);
        if (field == null) {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new BeanMappingException(e);
            }
            if (field != null) {
                this.fieldCache.put(fieldName, field);
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastClass getFastClass(Class<?> clazz) {
        String clazzName = clazz.getName();
        FastClass fc = this.fastClassCache.get(clazzName);
        if (null == fc) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                Method[] methods;
                fc = this.fastClassCache.get(clazzName);
                if (fc != null) {
                    return fc;
                }
                fc = FastClass.create(clazz);
                String className = clazz.getName();
                for (Method m : methods = clazz.getMethods()) {
                    String key = this.buildMethodKey(className, m.getName(), m.getParameterTypes());
                    this.methodCache.put(key, m);
                    this.fastMethodCache.put(key, fc.getMethod(m));
                }
                this.allMethodCache.put(clazzName, methods);
                this.fastClassCache.put(clazzName, fc);
            }
            return this.fastClassCache.get(clazzName);
        }
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJavaClassCache(Class clazz) {
        String clazzName = clazz.getName();
        Class cl = this.classCache.get(clazzName);
        if (null == cl) {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                Method[] methods;
                cl = this.classCache.get(clazzName);
                if (cl != null) {
                    return;
                }
                for (Method m : methods = clazz.getMethods()) {
                    String key = this.buildMethodKey(clazzName, m.getName(), m.getParameterTypes());
                    this.methodCache.put(key, m);
                }
                this.allMethodCache.put(clazzName, methods);
            }
        }
    }

    private String buildMethodKey(String clazzName, String methodName, Class[] parameters) {
        String paramName = "";
        for (Class p : parameters) {
            paramName = paramName + p.getName() + "#";
        }
        return clazzName + "#" + methodName + "#" + paramName;
    }
}

