/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.introspect;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.introspect.AbstractBatchExecutor;
import com.agapple.mapping.core.introspect.FastPropertyGetExecutor;
import com.agapple.mapping.core.introspect.FastPropertySetExecutor;
import com.agapple.mapping.core.introspect.Introspector;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.reflect.FastMethod;

public class PropertyBatchExecutor
extends AbstractBatchExecutor {
    private BulkBean bulkBean = null;

    public PropertyBatchExecutor(Introspector is, Class<?> clazz, String[] fields, Class[] args) {
        super(clazz);
        this.bulkBean = this.buildGetBulkBean(is, clazz, fields, args);
    }

    @Override
    public Object[] gets(Object obj) throws BeanMappingException {
        return this.bulkBean.getPropertyValues(obj);
    }

    @Override
    public void sets(Object obj, Object[] values) throws BeanMappingException {
        this.bulkBean.setPropertyValues(obj, values);
    }

    @Override
    public final boolean isAlive() {
        return this.bulkBean != null;
    }

    protected BulkBean buildGetBulkBean(Introspector is, Class<?> clazz, String[] fields, Class[] args) {
        if (fields.length != args.length) {
            throw new BeanMappingException("fields and args size is not match!");
        }
        String[] getters = new String[fields.length];
        String[] setters = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String property = fields[i];
            Class arg = args[i];
            FastMethod setMethod = FastPropertySetExecutor.discover(is, clazz, property, arg);
            FastMethod getMethod = FastPropertyGetExecutor.discover(is, clazz, property);
            if (setMethod == null) {
                throw new BeanMappingException("class[" + clazz.getName() + "] field[" + property + "] arg[" + arg.getName() + "] set Method is not exist!");
            }
            if (getMethod == null) {
                throw new BeanMappingException("class[" + clazz.getName() + "] field[" + property + "] get Method is not exist!");
            }
            if (getMethod.getReturnType() != arg) {
                throw new BeanMappingException("class[" + clazz.getName() + "] field[" + property + "] getMethod does not match declared type");
            }
            setters[i] = setMethod.getName();
            getters[i] = getMethod.getName();
        }
        this.bulkBean = BulkBean.create(clazz, (String[])getters, (String[])setters, (Class[])args);
        return this.bulkBean;
    }
}

