/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.introspect;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.introspect.AbstractExecutor;
import com.agapple.mapping.core.introspect.GetExecutor;
import com.agapple.mapping.core.introspect.Introspector;
import java.lang.reflect.Method;

public class PropertyGetExecutor
extends AbstractExecutor
implements GetExecutor {
    private Method method;

    public PropertyGetExecutor(Introspector is, Class<?> clazz, String identifier) {
        super(clazz, identifier);
        this.method = PropertyGetExecutor.discover(is, clazz, identifier);
    }

    @Override
    public Object invoke(Object obj) throws BeanMappingException {
        try {
            return this.method == null ? null : this.method.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            throw new BeanMappingException(e);
        }
    }

    @Override
    public boolean isAlive() {
        return this.method != null;
    }

    public static Method discover(Introspector is, Class<?> clazz, String property) {
        Method method = PropertyGetExecutor.discoverGet(is, "get", clazz, property);
        if (method == null && (method = PropertyGetExecutor.discoverGet(is, "is", clazz, property)) == null && property.startsWith("is")) {
            property = property.substring("is".length());
            method = PropertyGetExecutor.discoverGet(is, "is", clazz, property);
        }
        return method;
    }

    public static Method discoverGet(Introspector is, String which, Class<?> clazz, String property) {
        Method method = null;
        int start = which.length();
        StringBuilder sb = new StringBuilder(which);
        sb.append(property);
        char c = sb.charAt(start);
        sb.setCharAt(start, Character.toUpperCase(c));
        method = is.getJavaMethod(clazz, sb.toString());
        if (method == null) {
            sb.setCharAt(start, Character.toLowerCase(c));
            method = is.getJavaMethod(clazz, sb.toString());
        }
        return method;
    }

    public Method getMethod() {
        return this.method;
    }
}

