/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.process;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.introspect.GetExecutor;
import com.agapple.mapping.core.introspect.SetExecutor;
import com.agapple.mapping.core.process.ValueProcess;
import com.agapple.mapping.core.process.ValueProcessContext;
import java.util.List;

public class ValueProcessInvocation {
    private ValueProcessContext context;
    private List<ValueProcess> processes;
    private GetExecutor getExecutor;
    private SetExecutor setExecutor;
    private int currentIndex = -1;

    public ValueProcessInvocation(GetExecutor getExecutor, SetExecutor setExecutor, ValueProcessContext context, List<ValueProcess> processes) {
        this.getExecutor = getExecutor;
        this.setExecutor = setExecutor;
        this.context = context;
        this.processes = processes;
    }

    public Object getInitialValue() {
        return this.invokeGetExecutor();
    }

    public Object proceed(Object value) throws BeanMappingException {
        if (this.processes == null) {
            return this.invokeSetExecutor(value);
        }
        if (this.currentIndex == this.processes.size() - 1) {
            return this.invokeSetExecutor(value);
        }
        ValueProcess vp = this.processes.get(++this.currentIndex);
        return vp.process(value, this);
    }

    protected Object invokeGetExecutor() {
        if (this.isGetBatch()) {
            return this.context.getHolder().getNext();
        }
        if (this.getExecutor != null) {
            return this.getExecutor.invoke(this.context.getParam().getSrcRef());
        }
        return null;
    }

    protected Object invokeSetExecutor(Object value) {
        if (this.isSetBatch()) {
            this.context.getHolder().setObject(value);
            return value;
        }
        if (this.setExecutor != null) {
            return this.setExecutor.invoke(this.context.getParam().getTargetRef(), value);
        }
        return null;
    }

    public boolean isDebug() {
        return this.getContext().getBeanObject().getBehavior().isDebug();
    }

    private boolean isGetBatch() {
        return this.context.getBeanObject().isBatch() && this.context.getBeanObject().getGetBatchExecutor() != null;
    }

    private boolean isSetBatch() {
        return this.context.getBeanObject().isBatch() && this.context.getBeanObject().getSetBatchExecutor() != null;
    }

    public ValueProcessContext getContext() {
        return this.context;
    }
}

