/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.config.BeanMappingField;
import com.agapple.mapping.core.helper.ReflectionHelper;
import com.agapple.mapping.core.process.ValueProcess;
import com.agapple.mapping.core.process.ValueProcessInvocation;
import com.agapple.mapping.process.convetor.Convertor;
import com.agapple.mapping.process.convetor.ConvertorHelper;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertorValueProcess
implements ValueProcess {
    private static final Logger logger = LoggerFactory.getLogger(ConvertorValueProcess.class);

    @Override
    public Object process(Object value, ValueProcessInvocation invocation) throws BeanMappingException {
        if (value != null && !invocation.getContext().getCurrentField().isMapping()) {
            BeanMappingField currentField = invocation.getContext().getCurrentField();
            String customConvertorName = currentField.getConvertor();
            Convertor convertor = currentField.getConvertorRef();
            if (convertor == null && currentField.getConvertorClass() != null) {
                Class clazz = currentField.getConvertorClass();
                convertor = (Convertor)ReflectionHelper.newInstance(clazz);
                currentField.setConvertorRef(convertor);
            }
            if (StringUtils.isNotEmpty((String)customConvertorName)) {
                convertor = ConvertorHelper.getInstance().getConvertor(customConvertorName);
            } else if (convertor == null) {
                Class targetClass;
                Class<?> srcClass = currentField.getSrcField().getClazz();
                if (srcClass == null || !srcClass.isPrimitive()) {
                    srcClass = value.getClass();
                }
                if ((targetClass = currentField.getTargetField().getClazz()) != null && (convertor = ConvertorHelper.getInstance().getConvertor(srcClass, targetClass)) == null && !targetClass.isAssignableFrom(srcClass) && logger.isWarnEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("srcName[" + currentField.getSrcField().getName());
                    builder.append("],srcClass[" + ObjectUtils.toString(srcClass, (String)"null"));
                    builder.append("],targetName[" + currentField.getTargetField().getName());
                    builder.append("],targetClass[" + ObjectUtils.toString((Object)targetClass, (String)"null") + "]");
                    logger.warn(builder.toString() + " convertor is null!");
                }
            }
            if (convertor != null && currentField.getTargetField().getClazz() != null) {
                List<Class> componentClasses = currentField.getTargetField().getComponentClasses();
                Class[] array = null;
                if (componentClasses != null && componentClasses.size() > 0) {
                    array = componentClasses.toArray(new Class[componentClasses.size()]);
                }
                value = array != null ? convertor.convertCollection(value, currentField.getTargetField().getClazz(), array) : convertor.convert(value, currentField.getTargetField().getClazz());
            }
        }
        return invocation.proceed(value);
    }
}

