/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convetor;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.process.convetor.AbastactConvertor;
import com.agapple.mapping.process.convetor.StringAndCommonConvertor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CommonAndCommonConvertor {

    public static class CommonToCommon
    extends AbastactConvertor {
        private static final Integer ZERO = new Integer(0);
        private static final Integer ONE = new Integer(1);

        private Object toCommon(Class srcClass, Class targetClass, Number value) {
            if (targetClass.equals(value.getClass())) {
                return value;
            }
            if (targetClass == Integer.class || targetClass == Integer.TYPE) {
                long longValue = value.longValue();
                if (longValue > Integer.MAX_VALUE) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too large for " + targetClass.getName());
                }
                if (longValue < Integer.MIN_VALUE) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too small " + targetClass.getName());
                }
                return value.intValue();
            }
            if (targetClass == Long.class || targetClass == Long.TYPE) {
                return value.longValue();
            }
            if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
                long longValue = value.longValue();
                return longValue > 0L;
            }
            if (targetClass == Byte.class || targetClass == Byte.TYPE) {
                long longValue = value.longValue();
                if (longValue > 127L) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too large for " + targetClass.getName());
                }
                if (longValue < -128L) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too small " + targetClass.getName());
                }
                return value.byteValue();
            }
            if (targetClass == Double.class || targetClass == Double.TYPE) {
                return value.doubleValue();
            }
            if (targetClass == BigDecimal.class) {
                if (value instanceof Float || value instanceof Double) {
                    return new BigDecimal(value.toString());
                }
                if (value instanceof BigInteger) {
                    return new BigDecimal((BigInteger)value);
                }
                return BigDecimal.valueOf(value.longValue());
            }
            if (targetClass == BigInteger.class) {
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return BigInteger.valueOf(value.longValue());
            }
            if (targetClass == Short.class || targetClass == Short.TYPE) {
                long longValue = value.longValue();
                if (longValue > 32767L) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too large for " + targetClass.getName());
                }
                if (longValue < -32768L) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too small " + targetClass.getName());
                }
                return value.shortValue();
            }
            if (targetClass == Float.class || targetClass == Float.TYPE) {
                double doubleValue = value.doubleValue();
                if (doubleValue > 3.4028234663852886E38) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too large for " + targetClass.getName());
                }
                if (doubleValue < (double)1.4E-45f) {
                    throw new BeanMappingException(srcClass.getName() + " value '" + value + "' is too small for " + targetClass.getName());
                }
                return Float.valueOf(value.floatValue());
            }
            if (targetClass == Character.class || targetClass == Character.TYPE) {
                long longValue = value.longValue();
                return Character.valueOf((char)longValue);
            }
            throw new BeanMappingException("Unsupported convert: [" + srcClass.getName() + "," + targetClass.getName() + "]");
        }

        private Object toCommon(Class srcClass, Class targetClass, BigDecimal value) {
            if (targetClass == srcClass) {
                return value;
            }
            if (targetClass == BigInteger.class) {
                return value.toBigInteger();
            }
            StringAndCommonConvertor.StringToCommon strConvetor = new StringAndCommonConvertor.StringToCommon();
            return strConvetor.convert(value.toPlainString(), targetClass);
        }

        private Object toCommon(Class srcClass, Class targetClass, BigInteger value) {
            if (targetClass == srcClass) {
                return value;
            }
            if (targetClass == BigDecimal.class) {
                return new BigDecimal(value);
            }
            StringAndCommonConvertor.StringToCommon strConvetor = new StringAndCommonConvertor.StringToCommon();
            return strConvetor.convert(value.toString(), targetClass);
        }

        @Override
        public Object convert(Object src, Class targetClass) {
            Class<?> srcClass = src.getClass();
            if (srcClass == Integer.class || srcClass == Integer.TYPE) {
                return this.toCommon(srcClass, targetClass, (Integer)src);
            }
            if (srcClass == Long.class || srcClass == Long.TYPE) {
                return this.toCommon(srcClass, targetClass, (Long)src);
            }
            if (srcClass == Boolean.class || srcClass == Boolean.TYPE) {
                Boolean boolValue = (Boolean)src;
                return this.toCommon(srcClass, targetClass, boolValue != false ? ONE : ZERO);
            }
            if (srcClass == Byte.class || srcClass == Byte.TYPE) {
                return this.toCommon(Double.class, targetClass, (Byte)src);
            }
            if (srcClass == Double.class || srcClass == Double.TYPE) {
                return this.toCommon(srcClass, targetClass, (Double)src);
            }
            if (srcClass == BigDecimal.class) {
                return this.toCommon(srcClass, targetClass, (BigDecimal)src);
            }
            if (srcClass == BigInteger.class) {
                return this.toCommon(srcClass, targetClass, (BigInteger)src);
            }
            if (srcClass == Float.class || srcClass == Float.TYPE) {
                return this.toCommon(srcClass, targetClass, (Float)src);
            }
            if (srcClass == Short.class || srcClass == Short.TYPE) {
                return this.toCommon(srcClass, targetClass, (Short)src);
            }
            if (srcClass == Character.class || srcClass == Character.TYPE) {
                Character charvalue = (Character)src;
                return this.toCommon(srcClass, targetClass, (int)charvalue.charValue());
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + targetClass.getName() + "]");
        }
    }
}

