/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convetor;

import com.agapple.mapping.process.convetor.Convertor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConvertorRepository {
    private static final String SEPERATOR = ":";
    private static String int_name = Integer.class.getName();
    private static String short_name = Short.class.getName();
    private static String long_name = Long.class.getName();
    private static String char_name = Character.class.getName();
    private static String void_name = Void.class.getName();
    private static String double_name = Double.class.getName();
    private static String float_name = Float.class.getName();
    private static String byte_name = Byte.class.getName();
    private static String bool_name = Boolean.class.getName();
    private Map<String, Convertor> convertors = new ConcurrentHashMap<String, Convertor>(10);

    public Convertor getConvertor(Class src, Class dest) {
        return this.convertors.get(this.mapperConvertorName(src, dest));
    }

    public Convertor getConvertor(String alias) {
        return this.convertors.get(alias);
    }

    public void registerConvertor(Class src, Class dest, Convertor convertor) {
        String key = this.mapperConvertorName(src, dest);
        if (convertor != null) {
            this.convertors.put(key, convertor);
        }
    }

    public void registerConvertor(String alias, Convertor convertor) {
        if (convertor != null) {
            this.convertors.put(alias, convertor);
        }
    }

    private String mapperConvertorName(Class src, Class dest) {
        String name1 = this.getName(src);
        String name2 = this.getName(dest);
        return name1 + SEPERATOR + name2;
    }

    private String getName(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return int_name;
            }
            if (type == Short.TYPE) {
                return short_name;
            }
            if (type == Long.TYPE) {
                return long_name;
            }
            if (type == Character.TYPE) {
                return char_name;
            }
            if (type == Void.TYPE) {
                return void_name;
            }
            if (type == Double.TYPE) {
                return double_name;
            }
            if (type == Float.TYPE) {
                return float_name;
            }
            if (type == Byte.TYPE) {
                return byte_name;
            }
            if (type == Boolean.TYPE) {
                return bool_name;
            }
        }
        return type.getName();
    }
}

