/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convetor;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.process.convetor.AbastactConvertor;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class SqlDateAndDateConvertor {

    public static class DateToSqlDateConvertor
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (Date.class.isInstance(src)) {
                Date date = (Date)src;
                long value = date.getTime();
                if (destClass.equals(java.sql.Date.class)) {
                    return new java.sql.Date(value);
                }
                if (destClass.equals(Time.class)) {
                    return new Time(value);
                }
                if (destClass.equals(Timestamp.class)) {
                    return new Timestamp(value);
                }
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class SqlDateToDateConvertor
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (Date.class != destClass) {
                throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
            }
            if (src instanceof java.sql.Date) {
                return new Date(((java.sql.Date)src).getTime());
            }
            if (src instanceof Timestamp) {
                return new Date(((Timestamp)src).getTime());
            }
            if (src instanceof Time) {
                return new Date(((Time)src).getTime());
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }
}

