/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convetor;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.process.convetor.AbastactConvertor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class StringAndCommonConvertor {

    public static class StringToCommon
    extends AbastactConvertor {
        protected static final Set TRUE_STRINGS = new HashSet<String>(Arrays.asList("true", "on", "yes", "y"));
        protected static final Set FALSE_STRINGS = new HashSet<String>(Arrays.asList("false", "null", "nul", "nil", "off", "no", "n"));

        protected Boolean booleanConvert(Object value) {
            block6: {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                if (value instanceof Number) {
                    return Math.abs(((Number)value).doubleValue()) < (double)1.4E-45f ? Boolean.FALSE : Boolean.TRUE;
                }
                if (value instanceof String) {
                    String strValue = ((String)value).trim();
                    try {
                        return Integer.parseInt(strValue) == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    catch (NumberFormatException e) {
                        strValue = strValue.toLowerCase();
                        if (TRUE_STRINGS.contains(strValue)) {
                            return Boolean.TRUE;
                        }
                        if (!FALSE_STRINGS.contains(strValue)) break block6;
                        return Boolean.FALSE;
                    }
                }
            }
            throw new BeanMappingException("Unsupported convert: [" + String.class + "," + Boolean.class.getName() + "]");
        }

        protected Character charConvert(Object value) {
            if (value instanceof Character) {
                return (Character)value;
            }
            if (value instanceof Number) {
                return new Character((char)((Number)value).intValue());
            }
            if (value instanceof String) {
                String strValue = ((String)value).trim();
                try {
                    return new Character((char)Integer.parseInt(strValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new BeanMappingException("Unsupported convert: [" + String.class + "," + Character.class.getName() + "]");
        }

        @Override
        public Object convert(Object src, Class destClass) {
            if (String.class.isInstance(src)) {
                String str = (String)src;
                if (destClass == Double.class || destClass == Double.TYPE) {
                    return Double.valueOf(str);
                }
                if (destClass == Float.class || destClass == Float.TYPE) {
                    return Float.valueOf(str);
                }
                if (destClass == Boolean.class || destClass == Boolean.TYPE) {
                    return this.booleanConvert(str);
                }
                if (destClass == Integer.class || destClass == Integer.TYPE) {
                    return Integer.valueOf(str);
                }
                if (destClass == Short.class || destClass == Short.TYPE) {
                    return Short.valueOf(str);
                }
                if (destClass == Long.class || destClass == Long.TYPE) {
                    return Long.valueOf(str);
                }
                if (destClass == Byte.class || destClass == Byte.TYPE) {
                    return Byte.valueOf(str);
                }
                if (destClass == Character.class || destClass == Character.TYPE) {
                    return this.charConvert(str);
                }
                if (destClass == BigDecimal.class) {
                    return new BigDecimal(str);
                }
                if (destClass == BigInteger.class) {
                    return new BigInteger(str);
                }
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }
}

