/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convetor;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.process.convetor.AbastactConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class StringAndDateConvertor {
    public static final String DAY_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static class CalendarTimeToString
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (Calendar.class.isInstance(src)) {
                Calendar ca = (Calendar)src;
                return new DateTimeToString().convert(ca.getTime(), String.class);
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class CalendarDayToString
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (Calendar.class.isInstance(src)) {
                Calendar ca = (Calendar)src;
                return new DateDayToString().convert(ca.getTime(), String.class);
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class StringToCalendarTime
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (String.class.isInstance(src)) {
                Date dest = (Date)new StringToDateTime().convert(src, Date.class);
                GregorianCalendar result = new GregorianCalendar();
                result.setTime(dest);
                return result;
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class StringToCalendarDay
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (String.class.isInstance(src)) {
                Date dest = (Date)new StringToDateDay().convert(src, Date.class);
                GregorianCalendar result = new GregorianCalendar();
                result.setTime(dest);
                return result;
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class DateTimeToString
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (Date.class.isInstance(src)) {
                return new SimpleDateFormat(StringAndDateConvertor.TIME_FORMAT).format((Date)src);
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class DateDayToString
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (Date.class.isInstance(src)) {
                return new SimpleDateFormat(StringAndDateConvertor.DAY_FORMAT).format((Date)src);
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class StringToDateTime
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (String.class.isInstance(src)) {
                try {
                    return new SimpleDateFormat(StringAndDateConvertor.TIME_FORMAT).parse((String)src);
                }
                catch (ParseException e) {
                    throw new BeanMappingException("convert failed: [" + src + "," + destClass.getName() + "]", e);
                }
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }

    public static class StringToDateDay
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (String.class.isInstance(src)) {
                try {
                    return new SimpleDateFormat(StringAndDateConvertor.DAY_FORMAT).parse((String)src);
                }
                catch (ParseException e) {
                    throw new BeanMappingException("convert failed: [" + src + "," + destClass.getName() + "]", e);
                }
            }
            throw new BeanMappingException("Unsupported convert: [" + src + "," + destClass.getName() + "]");
        }
    }
}

