/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.convetor;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.process.convetor.AbastactConvertor;

public class StringAndEnumConvertor {

    public static class EnumToString
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (src.getClass().isEnum() && destClass == String.class) {
                return ((Enum)src).name();
            }
            throw new BeanMappingException("Unsupported convert: [" + src.getClass() + "," + destClass.getName() + "]");
        }
    }

    public static class StringToEnum
    extends AbastactConvertor {
        @Override
        public Object convert(Object src, Class destClass) {
            if (src instanceof String && destClass.isEnum()) {
                return Enum.valueOf(destClass, (String)src);
            }
            throw new BeanMappingException("Unsupported convert: [" + src.getClass() + "," + destClass.getName() + "]");
        }
    }
}

