/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.graphqlrepository;

import com.graphql_java_generator.client.graphqlrepository.ClassPathScanner;
import com.graphql_java_generator.client.graphqlrepository.EnableGraphQLRepositories;
import com.graphql_java_generator.client.graphqlrepository.GraphQLReactiveRepository;
import com.graphql_java_generator.client.graphqlrepository.GraphQLRepository;
import com.graphql_java_generator.util.GraphqlUtils;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.MultiValueMap;

abstract class AbstractGraphQLRepositoryProxyBeansRegistrar<T extends Annotation>
implements ImportBeanDefinitionRegistrar,
BeanClassLoaderAware {
    private static Logger logger = LoggerFactory.getLogger(AbstractGraphQLRepositoryProxyBeansRegistrar.class);
    private final Class<T> annotationClass;
    private ClassPathScanner classpathScanner;
    private ClassLoader classLoader;
    GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;

    public AbstractGraphQLRepositoryProxyBeansRegistrar(Class<T> annotationClass) {
        this.annotationClass = annotationClass;
        this.classpathScanner = new ClassPathScanner(false);
        this.classpathScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationClass));
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        String[] basePackages = AbstractGraphQLRepositoryProxyBeansRegistrar.getBasePackages(importingClassMetadata);
        if (basePackages != null) {
            for (String basePackage : basePackages) {
                this.registerGraphQLRepositoryProxyBeanFactories(basePackage, registry);
            }
        }
    }

    private static String[] getBasePackages(AnnotationMetadata importingClassMetadata) {
        MultiValueMap allAnnotationAttributes = importingClassMetadata.getAllAnnotationAttributes(EnableGraphQLRepositories.class.getName());
        if (allAnnotationAttributes != null && allAnnotationAttributes.size() > 0) {
            return (String[])allAnnotationAttributes.getFirst((Object)"basePackages");
        }
        return null;
    }

    private void registerGraphQLRepositoryProxyBeanFactories(String basePackage, BeanDefinitionRegistry registry) {
        try {
            for (BeanDefinition beanDefinition : this.classpathScanner.findCandidateComponents(basePackage)) {
                String value;
                Class<?> clazz = Class.forName(beanDefinition.getBeanClassName());
                T graphQLRepository = clazz.getAnnotation(this.annotationClass);
                if (graphQLRepository instanceof GraphQLRepository) {
                    value = ((GraphQLRepository)graphQLRepository).value();
                } else if (graphQLRepository instanceof GraphQLReactiveRepository) {
                    value = ((GraphQLReactiveRepository)graphQLRepository).value();
                } else {
                    throw new IllegalArgumentException("The annotationClass class should be either sddqs or GraphQLReactiveRepository, but is " + this.annotationClass.getClass().getName());
                }
                String beanName = value == null || value.equals("") ? this.graphqlUtils.getCamelCase(clazz.getSimpleName()) : value;
                GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
                proxyBeanDefinition.setBeanClass(clazz);
                ConstructorArgumentValues args = new ConstructorArgumentValues();
                args.addGenericArgumentValue((Object)this.classLoader);
                args.addGenericArgumentValue(clazz);
                proxyBeanDefinition.setConstructorArgumentValues(args);
                proxyBeanDefinition.setFactoryBeanName("graphQLRepositoryProxyBeanFactory");
                proxyBeanDefinition.setFactoryMethodName("createGraphQLRepositoryInvocationHandler");
                registry.registerBeanDefinition(beanName, (BeanDefinition)proxyBeanDefinition);
            }
        }
        catch (Exception e) {
            logger.error("Exception while creating proxy: " + e.getClass().getSimpleName() + " (" + e.getMessage() + ")");
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

