/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.Disposable;

public class SubscriptionClientReactiveImpl
implements SubscriptionClient {
    Disposable disposable;
    WebSocketSession session;

    public SubscriptionClientReactiveImpl(Disposable disposable, WebSocketSession session) {
        this.disposable = disposable;
        this.session = session;
    }

    @Override
    public void unsubscribe() throws GraphQLRequestExecutionException {
        try {
            if (this.session != null) {
                this.session.close(CloseStatus.NORMAL);
                this.session = null;
            }
            if (this.disposable != null) {
                this.disposable.dispose();
                this.disposable = null;
            }
        }
        catch (Exception e) {
            throw new GraphQLRequestExecutionException(e.getMessage(), e);
        }
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }
}

