/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.annotation.GraphQLIgnore;
import com.graphql_java_generator.annotation.GraphQLInputParameters;
import com.graphql_java_generator.annotation.GraphQLInputType;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.directive.DirectiveRegistry;
import com.graphql_java_generator.client.directive.DirectiveRegistryImpl;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.client.request.RawGraphQLString;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.text.StringEscapeUtils;

public class InputParameter {
    DirectiveRegistry directiveRegistry = DirectiveRegistryImpl.directiveRegistry;
    private static GraphqlUtils graphqlUtils = new GraphqlUtils();
    private static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    final String name;
    final String bindParameterName;
    final Object value;
    final InputParameterType type;
    final String graphQLTypeName;
    final GraphQLScalarType graphQLScalarType;
    private final boolean itemMandatory;
    private final int listDepth;
    private final boolean mandatory;

    public static InputParameter newBindParameter(String name, String bindParameterName, InputParameterType type, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        if (bindParameterName == null) {
            throw new NullPointerException("[Internal error] The bind parameter name is mandatory");
        }
        return new InputParameter(name, bindParameterName, null, type, graphQLTypeName, mandatory, listDepth, itemMandatory);
    }

    public static InputParameter newGraphQLVariableParameter(String name, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        return new InputParameter(name, name, null, InputParameterType.GRAPHQL_VARIABLE, graphQLTypeName, mandatory, listDepth, itemMandatory);
    }

    public static InputParameter newHardCodedParameter(String name, Object value, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        return new InputParameter(name, null, value, InputParameterType.HARD_CODED, graphQLTypeName, mandatory, listDepth, itemMandatory);
    }

    private InputParameter(String name, String bindParameterName, Object value, InputParameterType type, String graphQLTypeName, boolean mandatory, int listDepth, boolean itemMandatory) {
        if (name == null) {
            throw new NullPointerException("The input parameter's name is mandatory");
        }
        this.name = name;
        this.bindParameterName = bindParameterName;
        this.value = value;
        this.type = type;
        this.graphQLTypeName = graphQLTypeName;
        this.graphQLScalarType = graphQLTypeName == null ? null : graphqlClientUtils.getGraphQLScalarTypeFromName(graphQLTypeName);
        this.mandatory = mandatory;
        this.listDepth = listDepth;
        this.itemMandatory = itemMandatory;
    }

    private InputParameter(String name, String parameterName, Object value, InputParameterType type, Directive directive, Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        String localGraphQLCustomScalarType = null;
        boolean localMandatory = false;
        int localList = 0;
        boolean localItemMandatory = false;
        if (name == null) {
            throw new NullPointerException("The input parameter's name is mandatory");
        }
        if (directive != null) {
            Directive dirDef = this.directiveRegistry.getDirective(directive.getName());
            if (dirDef == null) {
                throw new GraphQLRequestPreparationException("Could not find directive definition for the directive '" + directive.getName() + "'");
            }
            boolean found = false;
            for (InputParameter param : dirDef.getArguments()) {
                if (!param.getName().equals(name)) continue;
                found = true;
                localGraphQLCustomScalarType = param.getGraphQLTypeName();
                localMandatory = param.isMandatory();
                localList = param.getListDepth();
                localItemMandatory = param.isItemMandatory();
            }
            if (!found) {
                throw new GraphQLRequestPreparationException("The parameter of name '" + name + "' has not been found for the directive '" + directive.getName() + "'");
            }
        } else {
            GraphQLInputParameters inputParams;
            if (owningClass.isInterface()) {
                try {
                    Method method = owningClass.getMethod("get" + graphqlUtils.getPascalCase(graphqlUtils.getJavaName(fieldName)), new Class[0]);
                    inputParams = method.getAnnotation(GraphQLInputParameters.class);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new GraphQLRequestPreparationException("Error while looking for the the getter for <" + fieldName + "> in the interface '" + owningClass.getName() + "'", e);
                }
            }
            try {
                Field field = owningClass.getDeclaredField(graphqlUtils.getJavaName(fieldName));
                inputParams = field.getAnnotation(GraphQLInputParameters.class);
            }
            catch (NoSuchFieldException | SecurityException e) {
                try {
                    Field field = owningClass.getSuperclass().getDeclaredField(graphqlUtils.getJavaName(fieldName));
                    inputParams = field.getAnnotation(GraphQLInputParameters.class);
                }
                catch (NoSuchFieldException | SecurityException e2) {
                    throw new GraphQLRequestPreparationException("Error while looking for the the field <" + fieldName + "> in the class '" + owningClass.getName() + "', not in its superclass: " + owningClass.getSuperclass().getName(), e);
                }
            }
            if (inputParams == null) {
                throw new GraphQLRequestPreparationException("The field <" + fieldName + "> of the class '" + owningClass.getName() + "' has no input parameters. Error while looking for its '" + parameterName + "' input parameter");
            }
            boolean found = false;
            for (int i = 0; i < inputParams.names().length; ++i) {
                if (!inputParams.names()[i].equals(name)) continue;
                found = true;
                localGraphQLCustomScalarType = inputParams.types()[i];
                localMandatory = inputParams.mandatories()[i];
                localList = inputParams.listDepths()[i];
                localItemMandatory = inputParams.itemsMandatory()[i];
            }
            if (!found) {
                throw new GraphQLRequestPreparationException("The parameter of name <" + parameterName + "> has not been found for the field <" + fieldName + "> of the class '" + owningClass.getName() + "'");
            }
        }
        this.name = name;
        this.bindParameterName = parameterName;
        this.value = value;
        this.type = type;
        this.graphQLTypeName = localGraphQLCustomScalarType;
        this.graphQLScalarType = graphqlClientUtils.getGraphQLScalarTypeFromName(this.graphQLTypeName);
        this.mandatory = localMandatory;
        this.listDepth = localList;
        this.itemMandatory = localItemMandatory;
    }

    public static List<InputParameter> readTokenizerForInputParameters(QueryTokenizer qt, Directive directive, Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        ArrayList<InputParameter> ret = new ArrayList<InputParameter>();
        InputParameterStep step = InputParameterStep.NAME;
        String parameterName = null;
        block14: while (qt.hasMoreTokens()) {
            String token;
            switch (token = qt.nextToken()) {
                case ":": {
                    continue block14;
                }
                case ",": {
                    if (step == InputParameterStep.NAME) continue block14;
                    throw new GraphQLRequestPreparationException("Misplaced comma for the field '" + fieldName + "' is not finished (no closing parenthesis)");
                }
                case ")": {
                    if (parameterName == null) {
                        throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + fieldName + "' (no parameter has been read)");
                    }
                    if (step != InputParameterStep.NAME) {
                        throw new GraphQLRequestPreparationException("Misplaced closing parenthesis for the field '" + fieldName + "' is not finished (no closing parenthesis)");
                    }
                    return ret;
                }
            }
            switch (step) {
                case NAME: {
                    parameterName = token;
                    step = InputParameterStep.VALUE;
                    break;
                }
                case VALUE: {
                    StringBuffer sb;
                    if (token.startsWith("?")) {
                        ret.add(new InputParameter(parameterName, token.substring(1), null, InputParameterType.OPTIONAL, directive, owningClass, fieldName));
                    } else if (token.startsWith("&")) {
                        ret.add(new InputParameter(parameterName, token.substring(1), null, InputParameterType.MANDATORY, directive, owningClass, fieldName));
                    } else if (token.startsWith("$")) {
                        ret.add(new InputParameter(parameterName, token.substring(1), null, InputParameterType.GRAPHQL_VARIABLE, directive, owningClass, fieldName));
                    } else if (token.equals("[") || token.equals("{")) {
                        sb = new StringBuffer(token);
                        boolean list = token.startsWith("[");
                        int listDepth = 0;
                        boolean withinAString = false;
                        int recursiveLevel = 1;
                        while (true) {
                            if (!qt.hasMoreTokens(true)) {
                                throw new GraphQLRequestPreparationException("Found the end of the GraphQL request before the end of the " + (list ? "list" : "object") + ": '" + sb.toString() + "'");
                            }
                            String previousToken = token;
                            token = qt.nextToken(true);
                            if (token.contentEquals("\"")) {
                                boolean doubleQuoteEscapedWithinAString;
                                boolean bl = doubleQuoteEscapedWithinAString = withinAString && previousToken.endsWith("\\");
                                if (doubleQuoteEscapedWithinAString) {
                                    sb.append("\\\\");
                                } else {
                                    withinAString = !withinAString;
                                    sb.append("\\");
                                }
                            }
                            sb.append(token);
                            if (withinAString) continue;
                            if (list && token.equals("[") || !list && token.equals("{")) {
                                ++recursiveLevel;
                                ++listDepth;
                                continue;
                            }
                            if ((list && token.equals("]") || !list && token.equals("}")) && --recursiveLevel == 0) break;
                        }
                        ret.add(new InputParameter(parameterName, null, new RawGraphQLString(sb.toString()), InputParameterType.GRAPHQL_VALUE, null, false, listDepth, false));
                    } else if (token.equals("\"")) {
                        sb = new StringBuffer();
                        while (true) {
                            if (!qt.hasMoreTokens(true)) {
                                throw new GraphQLRequestPreparationException("Found the end of the GraphQL request before the end of the string parameter '" + sb.toString() + "'");
                            }
                            token = qt.nextToken(true);
                            if (token.contentEquals("\"")) break;
                            sb.append(token);
                            if (!token.equals("\\")) continue;
                            sb.append(qt.nextToken(true));
                        }
                        ret.add(new InputParameter(parameterName, null, sb.toString(), InputParameterType.HARD_CODED, "String", true, 0, false));
                    } else {
                        Object parameterValue;
                        if (token.startsWith("\"") || token.endsWith("\"")) {
                            throw new GraphQLRequestPreparationException("Bad parameter value: parameter values should start and finish by \", or not having any \" at the beginning and end. But it's not the case for the value <" + token + "> of parameter <" + parameterName + ">. Maybe you wanted to add a bind parameter instead (bind parameter must start with a ? or a &");
                        }
                        if (directive != null) {
                            parameterValue = InputParameter.parseDirectiveArgumentValue(directive, parameterName, token);
                            InputParameter arg = new InputParameter(parameterName, null, parameterValue, InputParameterType.HARD_CODED, null, true, 0, false);
                            ret.add(arg);
                            directive.getArguments().add(arg);
                        } else {
                            parameterValue = InputParameter.parseInputParameterValue(owningClass, fieldName, parameterName, token);
                            ret.add(new InputParameter(parameterName, null, parameterValue, InputParameterType.HARD_CODED, null, true, 0, false));
                        }
                    }
                    step = InputParameterStep.NAME;
                }
            }
        }
        throw new GraphQLRequestPreparationException("The list of parameters for the field '" + fieldName + "' is not finished (no closing parenthesis)");
    }

    private static Object parseInputParameterValue(Class<?> owningClass, String fieldName, String parameterName, String parameterValue) throws GraphQLRequestPreparationException {
        Field field = graphqlUtils.getDeclaredField(owningClass, graphqlUtils.getJavaName(fieldName), true);
        GraphQLInputParameters graphQLInputParameters = field.getDeclaredAnnotation(GraphQLInputParameters.class);
        if (graphQLInputParameters == null) {
            throw new GraphQLRequestPreparationException("[Internal error] The field '" + fieldName + "' is lacking the GraphQLInputParameters annotation");
        }
        for (int i = 0; i < graphQLInputParameters.names().length; ++i) {
            if (!graphQLInputParameters.names()[i].equals(parameterName)) continue;
            try {
                return InputParameter.parseValueForInputParameter(parameterValue, graphQLInputParameters.types()[i], owningClass.getPackage().getName());
            }
            catch (Exception e) {
                throw new GraphQLRequestPreparationException("Could not read the value for the parameter '" + parameterName + "' of the field '" + fieldName + "' of the type '" + owningClass.getName() + "'");
            }
        }
        throw new GraphQLRequestPreparationException("[Internal error] Can't find the type for the parameter '" + parameterName + "' of the field '" + fieldName + "'");
    }

    private static Object parseDirectiveArgumentValue(Directive directive, String parameterName, String parameterValue) throws GraphQLRequestPreparationException {
        Directive directiveDefinition = directive.getDirectiveDefinition();
        for (InputParameter param : directiveDefinition.getArguments()) {
            if (!param.getName().equals(parameterName)) continue;
            try {
                return InputParameter.parseValueForInputParameter(parameterValue, param.getGraphQLTypeName(), directive.getPackageName());
            }
            catch (Exception e) {
                throw new GraphQLRequestPreparationException("Could not read the value for the parameter '" + parameterName + "' of the directive '" + directive.getName() + "'", e);
            }
        }
        throw new GraphQLRequestPreparationException("[Internal error] Can't find the argument '" + parameterName + "' of the directive '" + directive.getName() + "'");
    }

    private static Object parseValueForInputParameter(String parameterValue, String parameterType, String packageName) throws GraphQLRequestPreparationException {
        try {
            return graphqlUtils.parseValueForInputParameter(parameterValue, parameterType, graphqlUtils.getClass(packageName, parameterType));
        }
        catch (RuntimeException e) {
            throw new GraphQLRequestPreparationException(e.getMessage(), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueForGraphqlQuery(boolean writingGraphQLVariables, Map<String, Object> bindVariables) throws GraphQLRequestExecutionException {
        if (this.bindParameterName == null) {
            return this.getValueForGraphqlQuery(writingGraphQLVariables, this.value, this.graphQLTypeName, this.graphQLScalarType, false);
        }
        if (!(!this.type.equals((Object)InputParameterType.MANDATORY) && !this.type.equals((Object)InputParameterType.GRAPHQL_VARIABLE) || bindVariables != null && bindVariables.keySet().contains(this.bindParameterName))) {
            throw new GraphQLRequestExecutionException("The Bind Parameter for '" + this.bindParameterName + "' must be provided in the BindVariables map");
        }
        if (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName)) {
            return null;
        }
        return this.getValueForGraphqlQuery(writingGraphQLVariables, bindVariables.get(this.bindParameterName), this.graphQLTypeName, this.graphQLScalarType, this.type.equals((Object)InputParameterType.GRAPHQL_VARIABLE));
    }

    String getValueForGraphqlQuery(boolean writingGraphQLVariables, Object val, String graphQLTypeName, GraphQLScalarType graphQLScalarType, boolean graphQLVariable) throws GraphQLRequestExecutionException {
        if (val == null) {
            return null;
        }
        if (graphQLVariable && !writingGraphQLVariables) {
            return "$" + this.bindParameterName;
        }
        if (writingGraphQLVariables && val.getClass().isEnum()) {
            return "\"" + val.toString() + "\"";
        }
        if (val instanceof List) {
            return this.getListValue(writingGraphQLVariables, (List)val, graphQLTypeName, graphQLScalarType, graphQLVariable);
        }
        if (graphQLScalarType != null) {
            Object ret = graphQLScalarType.getCoercing().serialize(val);
            if (ret instanceof String) {
                return this.getStringValue((String)ret, graphQLVariable);
            }
            return ret.toString();
        }
        if (val instanceof RawGraphQLString) {
            return ((RawGraphQLString)val).toString();
        }
        if (val instanceof String) {
            return this.getStringValue((String)val, graphQLVariable);
        }
        if (val instanceof UUID) {
            return this.getStringValue(((UUID)val).toString(), graphQLVariable);
        }
        if (val.getClass().getAnnotation(GraphQLInputType.class) != null) {
            return this.getInputTypeStringValue(writingGraphQLVariables, val, graphQLVariable);
        }
        return val.toString();
    }

    private String getStringValue(String str, boolean graphQLVariable) {
        return "" + (graphQLVariable ? "" : "\\") + "\"" + StringEscapeUtils.escapeJson((String)StringEscapeUtils.escapeJson((String)str)) + (graphQLVariable ? "" : "\\") + "\"";
    }

    private String getListValue(boolean writingGraphQLVariables, List<?> list, String graphQLTypeName, GraphQLScalarType graphQLScalarType, boolean graphQLVariable) throws GraphQLRequestExecutionException {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < list.size(); ++index) {
            Object obj = list.get(index);
            result.append(this.getValueForGraphqlQuery(writingGraphQLVariables, obj, graphQLTypeName, graphQLScalarType, graphQLVariable));
            if (index >= list.size() - 1) continue;
            result.append(",");
        }
        return result.append("]").toString();
    }

    private String getInputTypeStringValue(boolean writingGraphQLVariables, Object object, boolean graphQLVariable) throws GraphQLRequestExecutionException {
        StringBuilder result = new StringBuilder("{");
        String separator = "";
        for (Field field : object.getClass().getDeclaredFields()) {
            Object val;
            if (field.isSynthetic() || field.getAnnotation(GraphQLIgnore.class) != null || (val = graphqlUtils.invokeGetter(object, field.getName())) == null) continue;
            result.append(separator).append(graphQLVariable ? "\"" : "").append(field.getName()).append(graphQLVariable ? "\"" : "").append(":").append(this.getValueForGraphqlQuery(writingGraphQLVariables, val, this.graphQLTypeName, graphqlClientUtils.getGraphQLCustomScalarType(field), graphQLVariable));
            separator = ",";
        }
        return result.append("}").toString();
    }

    public String getBindParameterName() {
        return this.bindParameterName;
    }

    public InputParameterType getType() {
        return this.type;
    }

    public String getGraphQLTypeName() {
        return this.graphQLTypeName;
    }

    public GraphQLScalarType getGraphQLScalarType() {
        return this.graphQLScalarType;
    }

    public boolean isItemMandatory() {
        return this.itemMandatory;
    }

    public int getListDepth() {
        return this.listDepth;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public static void appendInputParametersToGraphQLRequests(boolean writingGraphQLVariables, StringBuilder sb, List<InputParameter> inputParameters, Map<String, Object> parameters) throws GraphQLRequestExecutionException {
        if (inputParameters != null && inputParameters.size() > 0) {
            ArrayList<String> params = new ArrayList<String>();
            for (InputParameter param : inputParameters) {
                String stringValue = param.getValueForGraphqlQuery(writingGraphQLVariables, parameters);
                if (stringValue == null) continue;
                params.add(param.getName() + ":" + stringValue);
            }
            if (params.size() > 0) {
                sb.append("(");
                boolean writeComma = false;
                for (String param : params) {
                    if (writeComma) {
                        sb.append(",");
                    }
                    writeComma = true;
                    sb.append(param);
                }
                sb.append(")");
            }
        }
    }

    public static enum InputParameterType {
        HARD_CODED,
        MANDATORY,
        OPTIONAL,
        GRAPHQL_VALUE,
        GRAPHQL_VARIABLE;

    }

    private static enum InputParameterStep {
        NAME,
        VALUE;

    }
}

