/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.GraphqlUtils;
import com.graphql_java_generator.annotation.GraphQLInputType;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class InputParameter {
    private static GraphqlUtils graphqlUtils = new GraphqlUtils();
    private static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    final String name;
    final String bindParameterName;
    final Object value;
    final boolean mandatory;
    final GraphQLScalarType graphQLScalarType;

    @Deprecated
    public static InputParameter newBindParameter(String name, String bindParameterName, boolean mandatory) {
        return InputParameter.newBindParameter(name, bindParameterName, mandatory, null);
    }

    @Deprecated
    public static InputParameter newBindParameter(String name, String bindParameterName, boolean mandatory, GraphQLScalarType graphQLScalarType) {
        return new InputParameter(name, bindParameterName, null, mandatory, graphQLScalarType);
    }

    @Deprecated
    public static InputParameter newHardCodedParameter(String name, Object value) {
        return new InputParameter(name, null, value, true, null);
    }

    InputParameter(String name, String bindParameterName, Object value, boolean mandatory, GraphQLScalarType graphQLScalarType) {
        this.name = name;
        this.bindParameterName = bindParameterName;
        this.value = value;
        this.mandatory = mandatory;
        this.graphQLScalarType = graphQLScalarType;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueForGraphqlQuery(Map<String, Object> bindVariables) throws GraphQLRequestExecutionException {
        if (this.value == null) {
            if (this.mandatory && (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName))) {
                throw new GraphQLRequestExecutionException("The Bind Parameter for '" + this.bindParameterName + "' must be provided in the BindVariables map");
            }
            if (bindVariables == null || !bindVariables.keySet().contains(this.bindParameterName)) {
                return null;
            }
            return this.getValueForGraphqlQuery(bindVariables.get(this.bindParameterName), this.graphQLScalarType);
        }
        return this.getValueForGraphqlQuery(this.value, this.graphQLScalarType);
    }

    String getValueForGraphqlQuery(Object val, GraphQLScalarType graphQLScalarType) throws GraphQLRequestExecutionException {
        if (val == null) {
            return null;
        }
        if (val instanceof List) {
            return this.getListValue((List)val, graphQLScalarType);
        }
        if (graphQLScalarType != null) {
            Object ret = graphQLScalarType.getCoercing().serialize(val);
            if (ret instanceof String) {
                return this.getStringValue((String)ret);
            }
            return ret.toString();
        }
        if (val instanceof String) {
            return this.getStringValue((String)val);
        }
        if (val instanceof UUID) {
            return this.getStringValue(((UUID)val).toString());
        }
        if (val.getClass().getAnnotation(GraphQLInputType.class) != null) {
            return this.getInputTypeStringValue(val);
        }
        return val.toString();
    }

    private String getStringValue(String str) {
        return "\\\"" + str.replace("\"", "\\\"") + "\\\"";
    }

    private String getListValue(List<?> list, GraphQLScalarType graphQLScalarType) throws GraphQLRequestExecutionException {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < list.size(); ++index) {
            Object obj = list.get(index);
            result.append(this.getValueForGraphqlQuery(obj, graphQLScalarType));
            if (index >= list.size() - 1) continue;
            result.append(",");
        }
        return result.append("]").toString();
    }

    private String getInputTypeStringValue(Object object) throws GraphQLRequestExecutionException {
        StringBuilder result = new StringBuilder("{");
        String separator = "";
        for (Field field : object.getClass().getDeclaredFields()) {
            Object val = graphqlUtils.invokeGetter(object, field.getName());
            if (val == null) continue;
            result.append(separator);
            result.append(field.getName());
            result.append(": ");
            result.append(this.getValueForGraphqlQuery(val, graphqlClientUtils.getGraphQLCustomScalarType(field)));
            separator = ", ";
        }
        return result.append("}").toString();
    }
}

