/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.Scalars;
import graphql.annotations.GraphQLAnnotations;
import graphql.annotations.GraphQLDescription;
import graphql.annotations.GraphQLName;
import graphql.annotations.GraphQLNonNull;
import graphql.annotations.TypeFunction;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class DefaultTypeFunction
implements TypeFunction {
    public static TypeFunction instance = new DefaultTypeFunction();
    private static Map<String, BiFunction<Class<?>, AnnotatedType, GraphQLType>> registry = new ConcurrentHashMap();

    public static Class<DefaultTypeFunction> register(Class<?> klass, TypeFunction function) {
        registry.put(klass.getName(), function);
        return DefaultTypeFunction.class;
    }

    @Override
    public GraphQLType apply(Class<?> klass, AnnotatedType annotatedType) {
        Class<Object> t = klass;
        while (!registry.containsKey(t.getName())) {
            if (t.getSuperclass() == null && t.isInterface()) {
                t = Object.class;
                continue;
            }
            if ((t = t.getSuperclass()) != null) continue;
            throw new IllegalArgumentException("unsupported type");
        }
        GraphQLType result = registry.get(t.getName()).apply(klass, annotatedType);
        if (klass.getAnnotation(GraphQLNonNull.class) != null || annotatedType != null && annotatedType.getAnnotation(GraphQLNonNull.class) != null) {
            result = new graphql.schema.GraphQLNonNull(result);
        }
        return result;
    }

    static {
        DefaultTypeFunction.register(String.class, new StringFunction());
        DefaultTypeFunction.register(Boolean.class, new BooleanFunction());
        DefaultTypeFunction.register(Boolean.TYPE, new BooleanFunction());
        DefaultTypeFunction.register(Float.class, new FloatFunction());
        DefaultTypeFunction.register(Float.TYPE, new FloatFunction());
        DefaultTypeFunction.register(Double.class, new FloatFunction());
        DefaultTypeFunction.register(Double.TYPE, new FloatFunction());
        DefaultTypeFunction.register(Integer.class, new IntegerFunction());
        DefaultTypeFunction.register(Integer.TYPE, new IntegerFunction());
        DefaultTypeFunction.register(Long.class, new LongFunction());
        DefaultTypeFunction.register(Long.TYPE, new LongFunction());
        DefaultTypeFunction.register(AbstractList.class, new ListFunction());
        DefaultTypeFunction.register(List.class, new ListFunction());
        DefaultTypeFunction.register(Stream.class, new StreamFunction());
        DefaultTypeFunction.register(Enum.class, new EnumFunction());
        DefaultTypeFunction.register(Optional.class, new OptionalFunction());
        DefaultTypeFunction.register(Object.class, new ObjectFunction());
    }

    private static class ObjectFunction
    implements TypeFunction {
        private final Map<String, GraphQLTypeReference> processing = new ConcurrentHashMap<String, GraphQLTypeReference>();
        private final Map<String, GraphQLType> types = new ConcurrentHashMap<String, GraphQLType>();

        private ObjectFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            String typeName;
            GraphQLName name = aClass.getAnnotation(GraphQLName.class);
            String string = typeName = name == null ? aClass.getSimpleName() : name.value();
            if (this.processing.containsKey(typeName)) {
                return (GraphQLType)this.processing.get(typeName);
            }
            this.processing.put(typeName, new GraphQLTypeReference(typeName));
            Object type = aClass.isInterface() ? GraphQLAnnotations.iface(aClass) : GraphQLAnnotations.object(aClass);
            this.processing.remove(typeName);
            this.types.put(typeName, (GraphQLType)type);
            return type;
        }
    }

    private static class EnumFunction
    implements TypeFunction {
        private EnumFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            Class<?> enumClass = aClass;
            GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
            GraphQLName name = aClass.getAnnotation(GraphQLName.class);
            builder.name(name == null ? aClass.getSimpleName() : name.value());
            GraphQLDescription description = aClass.getAnnotation(GraphQLDescription.class);
            if (description != null) {
                builder.description(description.value());
            }
            List<?> constants = Arrays.asList(enumClass.getEnumConstants());
            Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).forEachOrdered(n -> {
                try {
                    Field field = aClass.getField((String)n);
                    GraphQLName fieldName = field.getAnnotation(GraphQLName.class);
                    GraphQLDescription fieldDescription = field.getAnnotation(GraphQLDescription.class);
                    Enum constant = constants.stream().filter(c -> c.name().contentEquals((CharSequence)n)).findFirst().get();
                    String name_ = fieldName == null ? n : fieldName.value();
                    builder.value(name_, (Object)constant.ordinal(), fieldDescription == null ? name_ : fieldDescription.value());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            });
            return builder.build();
        }
    }

    private static class OptionalFunction
    implements TypeFunction {
        private OptionalFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("Optional type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return (GraphQLType)instance.apply(klass, arg);
        }
    }

    private static class StreamFunction
    implements TypeFunction {
        private StreamFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("Stream type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return new GraphQLList((GraphQLType)instance.apply(klass, arg));
        }
    }

    private static class ListFunction
    implements TypeFunction {
        private ListFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("List type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return new GraphQLList((GraphQLType)instance.apply(klass, arg));
        }
    }

    private static class LongFunction
    implements TypeFunction {
        private LongFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLLong;
        }
    }

    private static class IntegerFunction
    implements TypeFunction {
        private IntegerFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLInt;
        }
    }

    private static class FloatFunction
    implements TypeFunction {
        private FloatFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLFloat;
        }
    }

    private static class BooleanFunction
    implements TypeFunction {
        private BooleanFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLBoolean;
        }
    }

    private static class StringFunction
    implements TypeFunction {
        private StringFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLString;
        }
    }
}

