/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLException;
import graphql.Internal;
import graphql.MutationNotSupportedError;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionParameters;
import graphql.execution.ExecutionStrategy;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleExecutionStrategy;
import graphql.execution.TypeInfo;
import graphql.execution.ValuesResolver;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.DataFetchParameters;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Internal
public class Execution {
    private final FieldCollector fieldCollector = new FieldCollector();
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final Instrumentation instrumentation;

    public Execution(ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, Instrumentation instrumentation) {
        this.queryStrategy = queryStrategy != null ? queryStrategy : new SimpleExecutionStrategy();
        this.mutationStrategy = mutationStrategy != null ? mutationStrategy : new SimpleExecutionStrategy();
        this.subscriptionStrategy = subscriptionStrategy != null ? subscriptionStrategy : new SimpleExecutionStrategy();
        this.instrumentation = instrumentation;
    }

    public ExecutionResult execute(ExecutionId executionId, GraphQLSchema graphQLSchema, Object root, Document document, String operationName, Map<String, Object> args) {
        ExecutionContextBuilder executionContextBuilder = new ExecutionContextBuilder(new ValuesResolver(), this.instrumentation);
        ExecutionContext executionContext = executionContextBuilder.executionId(executionId).build(graphQLSchema, this.queryStrategy, this.mutationStrategy, this.subscriptionStrategy, root, document, operationName, args);
        return this.executeOperation(executionContext, root, executionContext.getOperationDefinition());
    }

    private GraphQLObjectType getOperationRootType(GraphQLSchema graphQLSchema, OperationDefinition.Operation operation) {
        if (operation == OperationDefinition.Operation.MUTATION) {
            return graphQLSchema.getMutationType();
        }
        if (operation == OperationDefinition.Operation.QUERY) {
            return graphQLSchema.getQueryType();
        }
        if (operation == OperationDefinition.Operation.SUBSCRIPTION) {
            return graphQLSchema.getSubscriptionType();
        }
        throw new GraphQLException("Unhandled case.  An extra operation enum has been added without code support");
    }

    private ExecutionResult executeOperation(ExecutionContext executionContext, Object root, OperationDefinition operationDefinition) {
        ExecutionResult result;
        InstrumentationContext dataFetchCtx = this.instrumentation.beginDataFetch(new DataFetchParameters(executionContext));
        OperationDefinition.Operation operation = operationDefinition.getOperation();
        GraphQLObjectType operationRootType = this.getOperationRootType(executionContext.getGraphQLSchema(), operation);
        if (operation == OperationDefinition.Operation.MUTATION && operationRootType == null) {
            return new ExecutionResultImpl(Collections.singletonList(new MutationNotSupportedError()));
        }
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters(executionContext.getGraphQLSchema(), operationRootType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        Map<String, List<Field>> fields = this.fieldCollector.collectFields(collectorParameters, operationDefinition.getSelectionSet());
        ExecutionParameters parameters = ExecutionParameters.newParameters().typeInfo(TypeInfo.newTypeInfo().type((GraphQLType)operationRootType)).source(root).fields(fields).build();
        try {
            result = operation == OperationDefinition.Operation.MUTATION ? this.mutationStrategy.execute(executionContext, parameters) : (operation == OperationDefinition.Operation.SUBSCRIPTION ? this.subscriptionStrategy.execute(executionContext, parameters) : this.queryStrategy.execute(executionContext, parameters));
        }
        catch (NonNullableFieldWasNullException e) {
            result = new ExecutionResultImpl(null, executionContext.getErrors());
        }
        dataFetchCtx.onEnd((Object)result);
        return result;
    }
}

