/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;
import org.dataloader.stats.context.IncrementBatchLoadCountByStatisticsContext;
import org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import org.dataloader.stats.context.IncrementCacheHitCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;

public class SimpleStatisticsCollector
implements StatisticsCollector {
    private final AtomicLong loadCount = new AtomicLong();
    private final AtomicLong batchInvokeCount = new AtomicLong();
    private final AtomicLong batchLoadCount = new AtomicLong();
    private final AtomicLong cacheHitCount = new AtomicLong();
    private final AtomicLong batchLoadExceptionCount = new AtomicLong();
    private final AtomicLong loadErrorCount = new AtomicLong();

    @Override
    public <K> long incrementLoadCount(IncrementLoadCountStatisticsContext<K> context) {
        return this.loadCount.incrementAndGet();
    }

    @Override
    @Deprecated
    public long incrementLoadCount() {
        return this.incrementLoadCount(null);
    }

    @Override
    public <K> long incrementLoadErrorCount(IncrementLoadErrorCountStatisticsContext<K> context) {
        return this.loadErrorCount.incrementAndGet();
    }

    @Override
    @Deprecated
    public long incrementLoadErrorCount() {
        return this.incrementLoadErrorCount(null);
    }

    @Override
    public <K> long incrementBatchLoadCountBy(long delta, IncrementBatchLoadCountByStatisticsContext<K> context) {
        this.batchInvokeCount.incrementAndGet();
        return this.batchLoadCount.addAndGet(delta);
    }

    @Override
    @Deprecated
    public long incrementBatchLoadCountBy(long delta) {
        return this.incrementBatchLoadCountBy(delta, null);
    }

    @Override
    public <K> long incrementBatchLoadExceptionCount(IncrementBatchLoadExceptionCountStatisticsContext<K> context) {
        return this.batchLoadExceptionCount.incrementAndGet();
    }

    @Override
    @Deprecated
    public long incrementBatchLoadExceptionCount() {
        return this.incrementBatchLoadExceptionCount(null);
    }

    @Override
    public <K> long incrementCacheHitCount(IncrementCacheHitCountStatisticsContext<K> context) {
        return this.cacheHitCount.incrementAndGet();
    }

    @Override
    @Deprecated
    public long incrementCacheHitCount() {
        return this.incrementCacheHitCount(null);
    }

    @Override
    public Statistics getStatistics() {
        return new Statistics(this.loadCount.get(), this.loadErrorCount.get(), this.batchInvokeCount.get(), this.batchLoadCount.get(), this.batchLoadExceptionCount.get(), this.cacheHitCount.get());
    }

    public String toString() {
        return this.getStatistics().toString();
    }
}

