/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.server.pkg;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.greenapi.client.pkg.api.exceptions.GreenApiClientException;
import com.greenapi.client.pkg.api.webhook.NotificationMapper;
import com.greenapi.client.pkg.api.webhook.WebhookHandler;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/green-api"})
public class WebhookServer {
    private static final Logger log = LogManager.getLogger(WebhookServer.class);
    private final NotificationMapper notificationMapper = new NotificationMapper(new ObjectMapper());
    private final WebhookHandler whatsappWebhookHandler;
    @Value(value="${green-api.webhookToken}")
    private String webhookToken;

    @PostMapping(value={"/async/webhook"})
    @ResponseStatus(value=HttpStatus.OK)
    public void receiveAsyncWebhook(@RequestBody String jsonString, @RequestHeader(required=false) String Authorization) {
        if (Authorization != null && !Authorization.replaceAll("Bearer ", "").equals(this.webhookToken)) {
            throw new GreenApiClientException("Invalid webhookToken - request is ignored");
        }
        CompletableFuture.runAsync(() -> this.whatsappWebhookHandler.handle(this.notificationMapper.get(jsonString)));
    }

    public WebhookServer(WebhookHandler whatsappWebhookHandler) {
        this.whatsappWebhookHandler = whatsappWebhookHandler;
    }
}

