/*
 * Decompiled with CFR 0.152.
 */
package com.greenapi.server.pkg;

import com.greenapi.client.pkg.api.webhook.NotificationMapper;
import com.greenapi.client.pkg.api.webhook.WebhookHandler;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/green-api"})
public class WebhookServer {
    private static final Logger log = LogManager.getLogger(WebhookServer.class);
    private final NotificationMapper notificationMapper = new NotificationMapper();
    private final WebhookHandler whatsappWebhookHandler;
    @Value(value="${green-api.webhookToken}")
    private String webhookToken;

    @PostMapping(value={"/async/webhook"})
    public ResponseEntity<Void> receiveAsyncWebhook(@RequestBody String jsonString, @RequestHeader(required=false) String Authorization) {
        if (!(Authorization != null && Authorization.replaceAll("Bearer ", "").equals(this.webhookToken) || Objects.equals(this.webhookToken, ""))) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).build();
        }
        CompletableFuture.runAsync(() -> this.whatsappWebhookHandler.handle(this.notificationMapper.get(jsonString)));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).build();
    }

    public WebhookServer(WebhookHandler whatsappWebhookHandler) {
        this.whatsappWebhookHandler = whatsappWebhookHandler;
    }
}

