/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.StringUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.jsoncoder.JSONCoderOption;
import com.jsonex.jsoncoder.coder.CoderArray;
import com.jsonex.jsoncoder.coder.CoderCollection;
import com.jsonex.jsoncoder.coder.CoderMap;
import com.jsonex.jsoncoder.coder.CoderObject;
import com.jsonex.treedoc.TDJSONWriter;
import com.jsonex.treedoc.TDNode;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class BeanCoder {
    private static final int MAX_OBJECTS = 10000;
    private static final int MAX_DEPTH = 50;
    public static final String HASH_KEY = "$hash";
    private static final String REF_PREFIX = "$ref:";

    public static TDNode encode(Object obj) {
        return BeanCoder.encode(obj, new BeanCoderContext(JSONCoderOption.global), null);
    }

    public static TDNode encode(Object obj, BeanCoderContext context, Type type) {
        return BeanCoder._encode(obj, context.reset(), type, new TDNode());
    }

    public static Object decode(TDNode obj, Type type) {
        return BeanCoder.decode(obj, type, null, "", new BeanCoderContext(JSONCoderOption.global));
    }

    public static <T> T decode(TDNode obj, T target) {
        return (T)BeanCoder.decode(obj, target.getClass(), target, "", new BeanCoderContext(JSONCoderOption.global));
    }

    public static <T> T deepClone(T src) {
        return (T)(src == null ? null : BeanCoder.decode(BeanCoder.encode(src), src.getClass()));
    }

    public static <T> T deepCopyTo(T src, T target) {
        return src == null ? null : (T)BeanCoder.decode(BeanCoder.encode(src), target);
    }

    static TDNode _encode(Object obj, BeanCoderContext ctx, Type type, TDNode target) {
        JSONCoderOption opt = ctx.getOption();
        int pathSize = ctx.objectPath.size();
        try {
            if (obj == null) {
                TDNode tDNode = target;
                return tDNode;
            }
            Class<?> cls = obj.getClass();
            if (obj.getClass().getName().startsWith("java.lang.reflect.") || cls == Object.class || cls == BigDecimal.class) {
                TDNode tDNode = target.setValue(obj.toString());
                return tDNode;
            }
            if (ClassUtil.isSimpleType(cls)) {
                TDNode tDNode = target.setValue(obj);
                return tDNode;
            }
            if (opt.isClassSkipped(cls)) {
                TDNode tDNode = target;
                return tDNode;
            }
            ICoder<?> coder = opt.findCoder(cls);
            if (coder != null) {
                TDNode tDNode = coder.encode(obj, type, ctx, target);
                return tDNode;
            }
            Object eqWrapper = opt.getEqualsWrapper(obj);
            try {
                int p = ctx.objectPath.indexOf(eqWrapper);
                if (p >= 0) {
                    TDNode tDNode = target.setValue(REF_PREFIX + StringUtil.appendRepeatedly((StringBuilder)new StringBuilder(), (String)"../", (int)(p + 1)));
                    return tDNode;
                }
            }
            catch (ClassCastException p) {
                // empty catch block
            }
            if (ctx.convertedObjects.size() > 10000 || ctx.objectPath.size() > 50) {
                TDNode p = target.setValue("[TRIMMED_DUE_TO_TOO_MANY_OBJECT]");
                return p;
            }
            TDNode orgResult = ctx.convertedObjects.get(eqWrapper);
            if (opt.dedupWithRef && orgResult != null) {
                String hash = (String)orgResult.getChildValue(HASH_KEY);
                if (hash == null) {
                    hash = Long.toHexString(BeanCoder.abs(eqWrapper.hashCode()));
                    orgResult.createChild(HASH_KEY).setValue(hash);
                }
                TDNode tDNode = target.setValue("$ref:#" + hash);
                return tDNode;
            }
            if (!(obj instanceof Collection && ((Collection)obj).isEmpty() || obj instanceof Map && ((Map)obj).isEmpty())) {
                ctx.objectPath.push(eqWrapper);
            }
            if (cls.isArray()) {
                CoderArray.getInstance().encode(obj, type, ctx, target);
            } else if (obj instanceof Collection) {
                CoderCollection.getInstance().encode((Collection)obj, type, ctx, target);
            } else if (obj instanceof Map) {
                CoderMap.getInstance().encode((Map)obj, type, ctx, target);
            } else {
                CoderObject.getInstance().encode(obj, type, ctx, target);
            }
            if (target.getType() == TDNode.Type.MAP && target.hasChildren()) {
                ctx.convertedObjects.put(eqWrapper, target);
            }
            TDNode tDNode = target;
            return tDNode;
        }
        catch (Exception ex) {
            throw new BeanCoderException(ex);
        }
        finally {
            if (ctx.objectPath.size() > pathSize) {
                ctx.objectPath.pop();
            }
        }
    }

    public static Object decode(TDNode jsonNode, Type type, Object targetObj, String name, BeanCoderContext ctx) {
        if (jsonNode == null) {
            return null;
        }
        Class cls = ClassUtil.getGenericClass((Type)type);
        int pathSize = ctx.objectPath.size();
        try {
            Object p;
            String s;
            if (jsonNode.getValue() instanceof String && cls != String.class && (s = (String)jsonNode.getValue()).startsWith(REF_PREFIX)) {
                String ref = s.substring(REF_PREFIX.length());
                if (ref.length() > 0 && ref.charAt(0) == '#') {
                    Object object = ctx.hashToObjectMap.get(ref.substring(1));
                    return object;
                }
                int level = ref.length() / 3;
                if (ctx.objectPath.size() < level) {
                    throw new BeanCoderException("Reference level exceeding objectPath:" + ctx.objectPath + "; ref:" + ref);
                }
                Object object = ctx.objectPath.get(level - 1);
                return object;
            }
            if (jsonNode.getType() == TDNode.Type.SIMPLE && (p = ClassUtil.objectToSimpleType((Object)jsonNode.getValue(), (Class)cls)) != null) {
                Object object = p;
                return object;
            }
            ICoder<?> coder = ctx.option.findCoder(cls);
            if (coder != null) {
                Object obj = coder.decode(jsonNode, type, targetObj, ctx);
                return obj;
            }
            if (cls == String.class) {
                String string = TDJSONWriter.getInstance().writeAsString(jsonNode);
                return string;
            }
            if (cls.isArray()) {
                Object object = CoderArray.getInstance().decode(jsonNode, type, targetObj, ctx);
                return object;
            }
            if (Collection.class.isAssignableFrom(cls)) {
                Collection collection = CoderCollection.getInstance().decode(jsonNode, type, targetObj, ctx);
                return collection;
            }
            if (Map.class.isAssignableFrom(cls)) {
                Map map = CoderMap.getInstance().decode(jsonNode, type, targetObj, ctx);
                return map;
            }
            Object object = CoderObject.getInstance().decode(jsonNode, type, targetObj, ctx);
            return object;
        }
        catch (Exception e) {
            throw new BeanCoderException("failed to decode:" + type + "; name=" + name, e);
        }
        finally {
            if (ctx.objectPath.size() > pathSize) {
                ctx.objectPath.pop();
            }
        }
    }

    private static int abs(int a) {
        return a < 0 ? -a : a;
    }
}

