/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.treedoc.ArrayCharSource;
import com.jsonex.treedoc.CharSource;
import com.jsonex.treedoc.ReaderCharSource;
import com.jsonex.treedoc.TDNode;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import lombok.Generated;

public abstract class DecodeReq<T> {
    private Type type;
    CharSource source;
    TDNode tdNode;
    String nodePath;
    T target;

    public DecodeReq<T> setReader(Reader reader) {
        this.source = reader == null ? null : new ReaderCharSource(reader);
        return this;
    }

    public DecodeReq<T> setJson(String jsonStr) {
        this.source = jsonStr == null ? null : new ArrayCharSource(jsonStr.toCharArray());
        return this;
    }

    public Type getType() {
        if (this.type == null) {
            Type superClass = this.getClass().getGenericSuperclass();
            this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        }
        return this.type;
    }

    public DecodeReq(Type type) {
        this.type = type;
    }

    public DecodeReq() {
    }

    public static <T> DecodeReq<T> of(Type type) {
        return new DecodeReq<T>(type){};
    }

    public static <T> DecodeReq<T> of(Class<T> cls) {
        return new DecodeReq<T>(cls){};
    }

    @Generated
    public DecodeReq<T> setType(Type type) {
        this.type = type;
        return this;
    }

    @Generated
    public CharSource getSource() {
        return this.source;
    }

    @Generated
    public DecodeReq<T> setSource(CharSource source) {
        this.source = source;
        return this;
    }

    @Generated
    public TDNode getTdNode() {
        return this.tdNode;
    }

    @Generated
    public DecodeReq<T> setTdNode(TDNode tdNode) {
        this.tdNode = tdNode;
        return this;
    }

    @Generated
    public String getNodePath() {
        return this.nodePath;
    }

    @Generated
    public DecodeReq<T> setNodePath(String nodePath) {
        this.nodePath = nodePath;
        return this;
    }

    @Generated
    public T getTarget() {
        return this.target;
    }

    @Generated
    public DecodeReq<T> setTarget(T target) {
        this.target = target;
        return this;
    }
}

