/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.treedoc;

import com.jsonex.core.factory.InjectableFactory;
import com.jsonex.treedoc.CharSource;
import com.jsonex.treedoc.EOFRuntimeException;
import java.util.function.Predicate;
import lombok.Generated;

public class ArrayCharSource
extends CharSource {
    public static final InjectableFactory<char[], ArrayCharSource> factory = InjectableFactory.of(param -> new ArrayCharSource((char[])param));
    final char[] buf;
    final int startIndex;
    final int endIndex;

    public ArrayCharSource(char[] buff) {
        this(buff, 0, buff.length);
    }

    @Override
    public char read() {
        if (this.isEof(0)) {
            throw new EOFRuntimeException();
        }
        return this.bookmark.append(this.buf[this.startIndex + this.bookmark.pos]);
    }

    @Override
    public char peek(int i) {
        if (this.isEof(i)) {
            throw new EOFRuntimeException();
        }
        return this.buf[this.startIndex + this.bookmark.pos + i];
    }

    @Override
    public boolean isEof(int i) {
        return this.startIndex + this.bookmark.pos + i >= this.endIndex;
    }

    @Override
    public boolean readUntil(int length, Predicate<CharSource> predicate, StringBuilder target) {
        int len;
        int startPos = this.bookmark.pos;
        boolean matched = false;
        for (len = 0; len < length && !this.isEof(0) && !(matched = predicate.test(this)); ++len) {
            this.read();
        }
        if (target != null) {
            target.append(this.buf, this.startIndex + startPos, len);
        }
        return matched;
    }

    @Generated
    public ArrayCharSource(char[] buf, int startIndex, int endIndex) {
        this.buf = buf;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }
}

