/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.treedoc;

import com.jsonex.treedoc.Bookmark;
import com.jsonex.treedoc.EOFRuntimeException;
import com.jsonex.treedoc.ParseRuntimeException;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CharSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CharSource.class);
    private static final int MAX_STRING_LEN = 20000;
    private static final String SPACE_CHARS = " \n\r\t";
    final Bookmark bookmark = new Bookmark();

    public abstract char read();

    public abstract char peek(int var1);

    public abstract boolean isEof(int var1);

    public Bookmark getBookmark() {
        return this.bookmark.clone();
    }

    public int getPos() {
        return this.bookmark.pos;
    }

    public boolean isEof() {
        return this.isEof(0);
    }

    public char peek() {
        return this.peek(0);
    }

    public abstract boolean readUntil(int var1, Predicate<CharSource> var2, StringBuilder var3);

    public boolean readUntil(Predicate<CharSource> predicate, StringBuilder target) {
        return this.readUntil(20000, predicate, target);
    }

    public boolean skipUntil(Predicate<CharSource> predicate) {
        return this.readUntil(Integer.MAX_VALUE, predicate, null);
    }

    public boolean readUntil(int length, final String terminator, final boolean include, StringBuilder target) {
        return this.readUntil(length, new Predicate<CharSource>(){

            @Override
            public boolean test(CharSource THIS) {
                return terminator.indexOf(THIS.peek(0)) >= 0 == include;
            }
        }, target);
    }

    public boolean readUntil(String terminator, StringBuilder target) {
        return this.readUntil(20000, terminator, true, target);
    }

    public String readUntil(String terminator) {
        StringBuilder sb = new StringBuilder();
        this.readUntil(terminator, sb);
        return sb.toString();
    }

    public boolean readUntil(String terminator, boolean include, StringBuilder target) {
        return this.readUntil(20000, terminator, include, target);
    }

    public boolean skipUntil(String terminator, boolean include) {
        return this.readUntil(Integer.MAX_VALUE, terminator, include, null);
    }

    public boolean skipUntil(String terminator) {
        return this.skipUntil(terminator, true);
    }

    public boolean skipSpaces() {
        return this.skipUntil(SPACE_CHARS, false);
    }

    public boolean read(int length, StringBuilder target) {
        return this.readUntil(length, new Predicate<CharSource>(){

            @Override
            public boolean test(CharSource THIS) {
                return false;
            }
        }, target);
    }

    public String read(int length) {
        StringBuilder sb = new StringBuilder();
        this.read(length, sb);
        return sb.toString();
    }

    public boolean skip(int length) {
        return this.read(length, null);
    }

    public boolean readUntilMatch(int length, final String str, boolean skipStr, StringBuilder target) {
        boolean matches = this.readUntil(length, new Predicate<CharSource>(){

            @Override
            public boolean test(CharSource THIS) {
                return CharSource.this.startsWidth(str);
            }
        }, target);
        if (matches && skipStr) {
            this.read(str.length(), null);
        }
        return matches;
    }

    public boolean readUntilMatch(String str, boolean skipStr, StringBuilder target) {
        return this.readUntilMatch(20000, str, skipStr, target);
    }

    public boolean skipUntilMatch(String str, boolean skipStr) {
        return this.readUntilMatch(Integer.MAX_VALUE, str, skipStr, null);
    }

    public String peak(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len && !this.isEof(i); ++i) {
            sb.append(this.peek(i));
        }
        return sb.toString();
    }

    public boolean startsWidth(String str) {
        if (this.isEof(str.length())) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.peek(i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private String getTermStrWithQuoteAndEscape(char quote) {
        switch (quote) {
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '`': {
                return "\\`";
            }
        }
        return "\\";
    }

    public String readQuotedString(char quote) {
        StringBuilder sb;
        block13: {
            char c;
            sb = new StringBuilder();
            String terminator = this.getTermStrWithQuoteAndEscape(quote);
            int pos = this.getPos();
            block11: while (true) {
                if (!this.readUntil(terminator, sb)) {
                    throw new EOFRuntimeException("Can't find matching quote at position:" + pos);
                }
                c = this.read();
                if (c == quote) break block13;
                c = this.read();
                switch (c) {
                    case 'b': {
                        sb.append('\b');
                        continue block11;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block11;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block11;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block11;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block11;
                    }
                    case 'u': {
                        String code = this.read(4);
                        try {
                            sb.append((char)Integer.parseInt(code, 16));
                            continue block11;
                        }
                        catch (NumberFormatException e) {
                            throw new ParseRuntimeException("escaped unicode with invalid number: " + code, this.getBookmark(), this.peak(5));
                        }
                    }
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '\\': 
                    case '`': {
                        sb.append(c);
                        continue block11;
                    }
                }
                break;
            }
            throw new ParseRuntimeException("invalid escape sequence:" + c, this.getBookmark(), this.peak(5));
        }
        return sb.toString();
    }

    public String dump() {
        StringBuilder result = new StringBuilder();
        result.append("," + this.bookmark + ": string=" + this.peak(5));
        return result.toString();
    }
}

