/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.treedoc;

import com.jsonex.core.factory.InjectableFactory;
import com.jsonex.treedoc.CharSource;
import com.jsonex.treedoc.EOFRuntimeException;
import java.io.Reader;
import java.util.function.Predicate;

public class ReaderCharSource
extends CharSource {
    public static final InjectableFactory<Reader, ReaderCharSource> factory = InjectableFactory.of(param -> new ReaderCharSource((Reader)param));
    final Reader reader;
    final char[] buf;
    private int loadPos;
    private boolean fullyLoaded;
    private int backupMark;
    StringBuilder backupTarget;

    public ReaderCharSource(Reader reader, int bufSize) {
        this.reader = reader;
        this.buf = new char[bufSize];
    }

    public ReaderCharSource(Reader reader) {
        this(reader, 1024);
    }

    private boolean fill() {
        if (this.fullyLoaded) {
            return false;
        }
        this.flushBackupTarget();
        int toLoad = this.getPos() + this.buf.length - this.loadPos;
        while (toLoad > 0) {
            int start = this.loadPos % this.buf.length;
            int len = this.reader.read(this.buf, start, Math.min(this.buf.length - start, toLoad));
            if (len < 0) {
                this.fullyLoaded = true;
                return false;
            }
            toLoad -= len;
            this.loadPos += len;
        }
        return true;
    }

    @Override
    public char read() {
        if (this.getPos() == this.loadPos) {
            this.fill();
            if (this.getPos() == this.loadPos) {
                throw new EOFRuntimeException();
            }
        }
        return this.bookmark.append(this.buf[this.getPos() % this.buf.length]);
    }

    @Override
    public char peek(int i) {
        if (this.isEof(i)) {
            throw new EOFRuntimeException();
        }
        int p = this.getPos() + i;
        return this.buf[p % this.buf.length];
    }

    @Override
    public boolean isEof(int i) {
        if (i >= this.buf.length) {
            throw new IllegalArgumentException("can't peek ahead more than buffer size characters");
        }
        int p = this.getPos() + i;
        if (p >= this.loadPos) {
            this.fill();
        }
        return p >= this.loadPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readUntil(int length, Predicate<CharSource> predicate, StringBuilder target) {
        if (target != null) {
            this.backupTarget = target;
            this.backupMark = this.getPos();
        }
        try {
            boolean matched = false;
            for (int len = 0; len < length && !this.isEof(0) && !(matched = predicate.test(this)); ++len) {
                this.read();
            }
            this.flushBackupTarget();
            boolean bl = matched;
            return bl;
        }
        finally {
            this.backupTarget = null;
        }
    }

    private void flushBackupTarget() {
        int start;
        if (this.getPos() == this.backupMark || this.backupTarget == null) {
            return;
        }
        int toBackup = this.getPos() - this.backupMark;
        if (toBackup < this.buf.length - (start = this.backupMark % this.buf.length)) {
            this.backupTarget.append(this.buf, start, toBackup);
        } else {
            this.backupTarget.append(this.buf, start, this.buf.length - start);
            this.backupTarget.append(this.buf, 0, start + toBackup - this.buf.length);
        }
        this.backupMark = this.getPos();
    }
}

