/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.treedoc;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.treedoc.ArrayCharSource;
import com.jsonex.treedoc.CharSource;
import com.jsonex.treedoc.EOFRuntimeException;
import com.jsonex.treedoc.ParseRuntimeException;
import com.jsonex.treedoc.ReaderCharSource;
import com.jsonex.treedoc.TDNode;
import java.io.Reader;

public class TDJSONParser {
    public static final InjectableInstance<TDJSONParser> instance = InjectableInstance.of(TDJSONParser.class);

    public static TDJSONParser getInstance() {
        return (TDJSONParser)instance.get();
    }

    public TDNode parse(Reader reader) {
        return this.parse((CharSource)ReaderCharSource.factory.get((Object)reader));
    }

    public TDNode parse(String jsonStr) {
        return this.parse((CharSource)ArrayCharSource.factory.get((Object)jsonStr.toCharArray()));
    }

    public TDNode parse(CharSource in) {
        return this.parse(in, new TDNode(null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDNode parse(CharSource in, TDNode node) {
        char c = this.skipSpaceAndComments(in);
        node.start = in.getPos();
        try {
            switch (c) {
                case '{': {
                    TDNode tDNode = this.parseMap(in, node);
                    return tDNode;
                }
                case '[': {
                    TDNode tDNode = this.parseArray(in, node);
                    return tDNode;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    in.read();
                    TDNode tDNode = node.setValue(in.readQuotedString(c));
                    return tDNode;
                }
            }
            String str = in.readUntil(",}]\n\r\t").trim();
            if ("null".equals(str)) {
                TDNode tDNode = node.setValue(null);
                return tDNode;
            }
            if ("true".equals(str)) {
                TDNode tDNode = node.setValue(true);
                return tDNode;
            }
            if ("false".equals(str)) {
                TDNode tDNode = node.setValue(false);
                return tDNode;
            }
            if (c == '-' || c >= '0' && c <= '9') {
                TDNode tDNode = node.setValue(this.parseNumber(str));
                return tDNode;
            }
            if (str.isEmpty()) {
                str = in.read(1);
            }
            TDNode tDNode = node.setValue(str);
            return tDNode;
        }
        finally {
            node.length = in.getPos() - node.start;
        }
    }

    private char skipSpaceAndComments(CharSource in) {
        block4: while (!in.isEof()) {
            in.skipSpaces();
            char c = in.peek();
            if (c != '/' || in.isEof(1)) {
                return c;
            }
            char c1 = in.peek(1);
            switch (c1) {
                case '/': {
                    if (!in.skipUntil("\n")) continue block4;
                    in.skip(1);
                    continue block4;
                }
                case '*': {
                    in.skip(2);
                    in.skipUntilMatch("*/", true);
                    continue block4;
                }
            }
            return c;
        }
        throw new EOFRuntimeException("In=" + in.dump());
    }

    private TDNode parseMap(CharSource in, TDNode node) {
        node.type = TDNode.Type.MAP;
        in.read();
        while (true) {
            String key;
            char c;
            if ((c = this.skipSpaceAndComments(in)) == '}') break;
            if (c == ',') {
                in.read();
                continue;
            }
            if (c == '\"' || c == '\'' || c == '`') {
                in.read();
                key = in.readQuotedString(c);
                c = this.skipSpaceAndComments(in);
                if (c != ':') {
                    throw new ParseRuntimeException("No ':' after key:" + key, in.getBookmark(), in.peak(5));
                }
                in.read();
            } else {
                key = in.readUntil(":");
                if (in.isEof()) {
                    throw new ParseRuntimeException("No ':' after key:" + key, in.getBookmark(), in.peak(5));
                }
                in.read();
            }
            this.parse(in, node.createChild(key));
        }
        in.read();
        return node;
    }

    private TDNode parseArray(CharSource in, TDNode node) {
        node.type = TDNode.Type.ARRAY;
        in.read();
        while (true) {
            char c;
            if ((c = this.skipSpaceAndComments(in)) == ']') break;
            if (c == ',') {
                in.read();
                c = this.skipSpaceAndComments(in);
                continue;
            }
            this.parse(in, node.createChild(null));
        }
        in.read();
        return node;
    }

    private Object parseNumber(String str) {
        if (str.indexOf(46) >= 0) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                return str;
            }
        }
        try {
            long value = Long.parseLong(str);
            if (value < Integer.MAX_VALUE) {
                return (int)value;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return str;
        }
    }
}

