/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.treedoc;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.core.util.StringUtil;
import com.jsonex.treedoc.TDNode;
import java.io.IOException;
import lombok.Generated;

public class TDJSONWriter {
    public static final InjectableInstance<TDJSONWriter> instance = InjectableInstance.of(TDJSONWriter.class);

    public static TDJSONWriter getInstance() {
        return (TDJSONWriter)instance.get();
    }

    public String writeAsString(TDNode node) {
        return this.writeAsString(node, new JSONOption());
    }

    public String writeAsString(TDNode node, JSONOption opt) {
        StringBuilder out = new StringBuilder();
        this.write(out, node, opt);
        return out.toString();
    }

    public void write(Appendable out, TDNode node, JSONOption opt) {
        this.write(out, node, opt, "");
    }

    public void write(Appendable out, TDNode node, JSONOption opt, String indentStr) {
        if (node == null) {
            out.append("null");
            return;
        }
        boolean isCompact = opt.getIndentFactor() == 0;
        String childIndentStr = "";
        if (!isCompact) {
            childIndentStr = indentStr + opt.getIndentStr();
        }
        switch (node.type) {
            case MAP: {
                this.writeMap(out, node, opt, indentStr, childIndentStr);
                return;
            }
            case ARRAY: {
                this.writeArray(out, node, opt, indentStr, childIndentStr);
                return;
            }
        }
        this.writeSimple(out, node, opt);
    }

    private void writeMap(Appendable out, TDNode node, JSONOption opt, String indentStr, String childIndentStr) {
        out.append('{');
        if (node.children != null) {
            for (int i = 0; i < node.children.size(); ++i) {
                TDNode cn = node.children.get(i);
                if (opt.indentFactor > 0) {
                    out.append('\n');
                    out.append(childIndentStr);
                }
                if (!StringUtil.isJavaIdentifier((String)cn.key) || opt.alwaysQuoteName) {
                    this.writeQuotedString(out, cn.key, opt.quoteChar);
                } else {
                    out.append(cn.key);
                }
                out.append(":");
                this.write(out, cn, opt, childIndentStr);
                if (i >= node.children.size() - 1) continue;
                out.append(",");
            }
            if (opt.indentFactor > 0 && !node.children.isEmpty()) {
                out.append('\n');
                out.append(indentStr);
            }
        }
        out.append('}');
    }

    private void writeArray(Appendable out, TDNode node, JSONOption opt, String indentStr, String childIndentStr) {
        out.append('[');
        if (node.children != null) {
            for (int i = 0; i < node.children.size(); ++i) {
                TDNode cn = node.children.get(i);
                if (opt.indentFactor > 0) {
                    out.append('\n');
                    out.append(childIndentStr);
                }
                this.write(out, cn, opt, childIndentStr);
                if (i >= node.children.size() - 1) continue;
                out.append(",");
            }
            if (opt.indentFactor > 0 && !node.children.isEmpty()) {
                out.append('\n');
                out.append(indentStr);
            }
        }
        out.append(']');
    }

    private void writeSimple(Appendable out, TDNode node, JSONOption opt) {
        if (node.value instanceof String) {
            this.writeQuotedString(out, (String)node.value, opt.quoteChar);
            return;
        }
        if (node.value instanceof Character) {
            this.writeQuotedString(out, String.valueOf(node.value), opt.quoteChar);
            return;
        }
        out.append(String.valueOf(node.value));
    }

    private void writeQuotedString(Appendable out, String str, char quoteChar) throws IOException {
        out.append(quoteChar);
        out.append(StringUtil.cEscape((String)str, (char)quoteChar, (boolean)true));
        out.append(quoteChar);
    }

    public static class JSONOption {
        private int indentFactor;
        boolean alwaysQuoteName = true;
        char quoteChar = (char)34;
        private String indentStr = "";

        public JSONOption setIndentFactor(int _indentFactor) {
            this.indentFactor = _indentFactor;
            this.indentStr = StringUtil.appendRepeatedly((StringBuilder)new StringBuilder(), (char)' ', (int)this.indentFactor).toString();
            return this;
        }

        @Generated
        public int getIndentFactor() {
            return this.indentFactor;
        }

        @Generated
        public boolean isAlwaysQuoteName() {
            return this.alwaysQuoteName;
        }

        @Generated
        public JSONOption setAlwaysQuoteName(boolean alwaysQuoteName) {
            this.alwaysQuoteName = alwaysQuoteName;
            return this;
        }

        @Generated
        public char getQuoteChar() {
            return this.quoteChar;
        }

        @Generated
        public JSONOption setQuoteChar(char quoteChar) {
            this.quoteChar = quoteChar;
            return this;
        }

        @Generated
        public String getIndentStr() {
            return this.indentStr;
        }
    }
}

