/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.treedoc;

import com.jsonex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class TDNode {
    final TDNode parent;
    Type type = Type.SIMPLE;
    final String key;
    Object value;
    List<TDNode> children;
    int start;
    int length;

    public TDNode() {
        this(null, null);
    }

    public TDNode createChild(String name) {
        if (this.children == null) {
            this.children = new ArrayList<TDNode>();
        }
        TDNode cn = new TDNode(this, name);
        this.children.add(cn);
        return cn;
    }

    public TDNode getChild(String name) {
        if (this.children == null) {
            return null;
        }
        for (TDNode cn : this.children) {
            if (!name.equals(cn.getKey())) continue;
            return cn;
        }
        return null;
    }

    public Object getChildValue(String name) {
        TDNode cn = this.getChild(name);
        return cn == null ? null : cn.getValue();
    }

    public TDNode getChild(int idx) {
        if (this.children == null || idx >= this.children.size()) {
            return null;
        }
        return this.children.get(idx);
    }

    public TDNode getChildByPath(String path) {
        return this.getChildByPath(path.split("/"), 0);
    }

    public TDNode getChildByPath(String[] path, int idx) {
        if (idx == path.length) {
            return this;
        }
        TDNode cn = StringUtil.isDigitOnly((String)path[idx]) ? this.getChild(Integer.parseInt(path[idx])) : this.getChild(path[idx]);
        return cn == null ? null : cn.getChildByPath(path, idx + 1);
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public int getChildrenSize() {
        return this.children == null ? 0 : this.children.size();
    }

    @Generated
    public TDNode(TDNode parent, String key) {
        this.parent = parent;
        this.key = key;
    }

    @Generated
    public TDNode getParent() {
        return this.parent;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public List<TDNode> getChildren() {
        return this.children;
    }

    @Generated
    public int getStart() {
        return this.start;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public TDNode setType(Type type) {
        this.type = type;
        return this;
    }

    @Generated
    public TDNode setValue(Object value) {
        this.value = value;
        return this;
    }

    @Generated
    public TDNode setChildren(List<TDNode> children) {
        this.children = children;
        return this;
    }

    @Generated
    public TDNode setStart(int start) {
        this.start = start;
        return this;
    }

    @Generated
    public TDNode setLength(int length) {
        this.length = length;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TDNode)) {
            return false;
        }
        TDNode other = (TDNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<TDNode> this$children = this.getChildren();
        List<TDNode> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TDNode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<TDNode> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TDNode(type=" + (Object)((Object)this.getType()) + ", key=" + this.getKey() + ", value=" + this.getValue() + ", children=" + this.getChildren() + ", start=" + this.getStart() + ", length=" + this.getLength() + ")";
    }

    public static enum Type {
        MAP,
        ARRAY,
        SIMPLE;

    }
}

