/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.jsoncoder.EqualsWrapper;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.jsoncoder.IFilter;
import com.jsonex.jsoncoder.SimpleFilter;
import com.jsonex.jsoncoder.coder.CoderAtomicInteger;
import com.jsonex.jsoncoder.coder.CoderBigInteger;
import com.jsonex.jsoncoder.coder.CoderClass;
import com.jsonex.jsoncoder.coder.CoderDate;
import com.jsonex.jsoncoder.coder.CoderEnum;
import com.jsonex.jsoncoder.coder.CoderXMLGregorianCalendar;
import com.jsonex.treedoc.json.TDJSONWriterOption;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class JSONCoderOption {
    static final JSONCoderOption global = new JSONCoderOption(null);
    private final JSONCoderOption parent;
    boolean ignoreReadOnly;
    Boolean ignoreSubClassFields;
    boolean showEnumName;
    boolean showType;
    boolean dedupWithRef;
    boolean showPrivateField;
    String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private final List<String> fallbackDateFormats = new ArrayList<String>();
    boolean alwaysMapKeyAsString;
    boolean errorOnUnknownProperty;
    private final Set<Class<?>> skippedClasses = new HashSet();
    private final Set<Class<?>> ignoreSubClassFieldsClasses = new HashSet();
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final List<ICoder<?>> coderList = new ArrayList();
    private final List<EqualsWrapper<?>> equalsWrapper = new ArrayList();
    private TDJSONWriterOption jsonOption = new TDJSONWriterOption();

    public JSONCoderOption() {
        this(global);
    }

    private JSONCoderOption(JSONCoderOption parent) {
        this.parent = parent;
    }

    public static JSONCoderOption create() {
        return new JSONCoderOption();
    }

    ICoder<?> findCoder(Class<?> cls) {
        for (ICoder<?> bc : this.coderList) {
            if (!bc.getType().isAssignableFrom(cls)) continue;
            return bc;
        }
        return this.parent == null ? null : this.parent.findCoder(cls);
    }

    public boolean isClassSkipped(Class<?> cls) {
        for (Class<?> skip : this.skippedClasses) {
            if (!skip.isAssignableFrom(cls)) continue;
            return true;
        }
        return this.parent != null && this.parent.isClassSkipped(cls);
    }

    public boolean isFieldSkipped(Class<?> cls, String field) {
        for (IFilter filter : this.filters) {
            if (!filter.getType().isAssignableFrom(cls) || filter.isFieldSkipped(field) != Boolean.TRUE) continue;
            return true;
        }
        return this.parent != null && this.parent.isFieldSkipped(cls, field);
    }

    Object getEqualsWrapper(Object obj) {
        for (EqualsWrapper<?> ew : this.equalsWrapper) {
            if (!ew.getType().isAssignableFrom(obj.getClass())) continue;
            return ew.newWrapper(obj);
        }
        return this.parent == null ? obj : this.parent.getEqualsWrapper(obj);
    }

    public Date parseDateFullback(String dateStr) throws ParseException {
        ParseException exp = null;
        for (String fmt : this.fallbackDateFormats) {
            try {
                return new SimpleDateFormat(fmt).parse(dateStr);
            }
            catch (ParseException e1) {
                exp = e1;
            }
        }
        if (this.parent == null) {
            throw exp == null ? new ParseException(dateStr, 0) : exp;
        }
        return this.parent.parseDateFullback(dateStr);
    }

    public boolean isIgnoreSubClassFields(Class<?> cls) {
        if (this.ignoreSubClassFields == Boolean.TRUE) {
            return true;
        }
        for (Class<?> iCls : this.ignoreSubClassFieldsClasses) {
            if (!iCls.isAssignableFrom(cls)) continue;
            return true;
        }
        return this.parent != null && this.parent.isIgnoreSubClassFields(cls);
    }

    public SimpleFilter getDefaultFilter() {
        return this.getSimpleFilterFor(Object.class);
    }

    public SimpleFilter getSimpleFilterFor(Class<?> cls) {
        for (IFilter filter : this.filters) {
            if (!(filter instanceof SimpleFilter) || filter.getType() != cls) continue;
            return (SimpleFilter)filter;
        }
        SimpleFilter result = SimpleFilter.of(cls);
        this.filters.add(0, result);
        return result;
    }

    public JSONCoderOption addSkippedClasses(Class<?> ... cls) {
        this.skippedClasses.addAll(Arrays.asList(cls));
        return this;
    }

    public JSONCoderOption addIgnoreSubClassFieldsClasses(Class<?> ... cls) {
        Collections.addAll(this.ignoreSubClassFieldsClasses, cls);
        return this;
    }

    public JSONCoderOption addCoder(ICoder<?> ... codes) {
        this.coderList.addAll(Arrays.asList(codes));
        return this;
    }

    public JSONCoderOption setJsonOption(boolean alwaysQuoteName, char quoteChar, int indentFactor) {
        this.jsonOption.setAlwaysQuoteName(alwaysQuoteName).setQuoteChar(quoteChar).setIndentFactor(indentFactor);
        return this;
    }

    @Generated
    public static JSONCoderOption getGlobal() {
        return global;
    }

    @Generated
    public boolean isIgnoreReadOnly() {
        return this.ignoreReadOnly;
    }

    @Generated
    public JSONCoderOption setIgnoreReadOnly(boolean ignoreReadOnly) {
        this.ignoreReadOnly = ignoreReadOnly;
        return this;
    }

    @Generated
    public Boolean getIgnoreSubClassFields() {
        return this.ignoreSubClassFields;
    }

    @Generated
    public JSONCoderOption setIgnoreSubClassFields(Boolean ignoreSubClassFields) {
        this.ignoreSubClassFields = ignoreSubClassFields;
        return this;
    }

    @Generated
    public boolean isShowEnumName() {
        return this.showEnumName;
    }

    @Generated
    public JSONCoderOption setShowEnumName(boolean showEnumName) {
        this.showEnumName = showEnumName;
        return this;
    }

    @Generated
    public boolean isShowType() {
        return this.showType;
    }

    @Generated
    public JSONCoderOption setShowType(boolean showType) {
        this.showType = showType;
        return this;
    }

    @Generated
    public boolean isDedupWithRef() {
        return this.dedupWithRef;
    }

    @Generated
    public JSONCoderOption setDedupWithRef(boolean dedupWithRef) {
        this.dedupWithRef = dedupWithRef;
        return this;
    }

    @Generated
    public boolean isShowPrivateField() {
        return this.showPrivateField;
    }

    @Generated
    public JSONCoderOption setShowPrivateField(boolean showPrivateField) {
        this.showPrivateField = showPrivateField;
        return this;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public JSONCoderOption setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Generated
    public List<String> getFallbackDateFormats() {
        return this.fallbackDateFormats;
    }

    @Generated
    public boolean isAlwaysMapKeyAsString() {
        return this.alwaysMapKeyAsString;
    }

    @Generated
    public JSONCoderOption setAlwaysMapKeyAsString(boolean alwaysMapKeyAsString) {
        this.alwaysMapKeyAsString = alwaysMapKeyAsString;
        return this;
    }

    @Generated
    public boolean isErrorOnUnknownProperty() {
        return this.errorOnUnknownProperty;
    }

    @Generated
    public JSONCoderOption setErrorOnUnknownProperty(boolean errorOnUnknownProperty) {
        this.errorOnUnknownProperty = errorOnUnknownProperty;
        return this;
    }

    @Generated
    public Set<Class<?>> getSkippedClasses() {
        return this.skippedClasses;
    }

    @Generated
    public Set<Class<?>> getIgnoreSubClassFieldsClasses() {
        return this.ignoreSubClassFieldsClasses;
    }

    @Generated
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Generated
    public List<ICoder<?>> getCoderList() {
        return this.coderList;
    }

    @Generated
    public List<EqualsWrapper<?>> getEqualsWrapper() {
        return this.equalsWrapper;
    }

    @Generated
    public TDJSONWriterOption getJsonOption() {
        return this.jsonOption;
    }

    @Generated
    public JSONCoderOption setJsonOption(TDJSONWriterOption jsonOption) {
        this.jsonOption = jsonOption;
        return this;
    }

    @Generated
    public TDJSONWriterOption setIndentFactor(int _indentFactor) {
        return this.getJsonOption().setIndentFactor(_indentFactor);
    }

    @Generated
    public boolean hasIndent() {
        return this.getJsonOption().hasIndent();
    }

    @Generated
    public int getIndentFactor() {
        return this.getJsonOption().getIndentFactor();
    }

    @Generated
    public boolean isAlwaysQuoteName() {
        return this.getJsonOption().isAlwaysQuoteName();
    }

    @Generated
    public TDJSONWriterOption setAlwaysQuoteName(boolean alwaysQuoteName) {
        return this.getJsonOption().setAlwaysQuoteName(alwaysQuoteName);
    }

    @Generated
    public char getQuoteChar() {
        return this.getJsonOption().getQuoteChar();
    }

    @Generated
    public TDJSONWriterOption setQuoteChar(char quoteChar) {
        return this.getJsonOption().setQuoteChar(quoteChar);
    }

    @Generated
    public String getIndentStr() {
        return this.getJsonOption().getIndentStr();
    }

    @Generated
    public TDJSONWriterOption setIndentStr(String indentStr) {
        return this.getJsonOption().setIndentStr(indentStr);
    }

    static {
        JSONCoderOption.global.coderList.add(new CoderDate());
        JSONCoderOption.global.coderList.add(new CoderEnum());
        JSONCoderOption.global.coderList.add(new CoderXMLGregorianCalendar());
        JSONCoderOption.global.coderList.add(new CoderAtomicInteger());
        JSONCoderOption.global.coderList.add(new CoderBigInteger());
        JSONCoderOption.global.coderList.add(new CoderClass());
        JSONCoderOption.global.skippedClasses.add(Format.class);
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd HH:mm:ss.SSS.Z");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy/MM/dd HH:mm:ss.SSS.Z");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd HH:mm:ss.SSS");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd HH:mm:ss");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd");
        JSONCoderOption.global.fallbackDateFormats.add("HH:mm:ss");
        global.getDefaultFilter().addProperties("copy");
    }
}

