/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder.coder;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.core.util.BeanProperty;
import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.ListUtil;
import com.jsonex.core.util.StringUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.jsoncoder.JSONCoderOption;
import com.jsonex.treedoc.TDNode;
import com.jsonex.treedoc.json.TDJSONWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoderObject
implements ICoder<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoderObject.class);
    public static final InjectableInstance<CoderObject> it = InjectableInstance.of(CoderObject.class);
    private static final String TYPE_KEY = "$type";

    public static CoderObject get() {
        return (CoderObject)it.get();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public TDNode encode(Object obj, Type type, BeanCoderContext ctx, TDNode target) {
        target.setType(TDNode.Type.MAP);
        JSONCoderOption opt = ctx.getOption();
        Class cls = obj.getClass();
        if (opt.isIgnoreSubClassFields(cls) && type != null) {
            cls = ClassUtil.getGenericClass((Type)type);
        }
        if (opt.isShowType() || cls != obj.getClass()) {
            target.createChild(TYPE_KEY).setValue((Object)obj.getClass().getName());
        }
        Map pds = ClassUtil.getProperties((Class)cls);
        for (BeanProperty pd : pds.values()) {
            if (!pd.isReadable(opt.isShowPrivateField()) || pd.isImmutable(opt.isShowPrivateField()) && opt.isIgnoreReadOnly() || pd.isTransient() || opt.isFieldSkipped(cls, pd.getName())) continue;
            try {
                TDNode cn;
                Type childType = pd.getGenericType();
                Object co = pd.get(obj);
                if (co == null || (cn = ctx.encode(co, childType, target.createChild(pd.getName()))).getType() != TDNode.Type.SIMPLE || cn.getValue() != null) continue;
                ListUtil.removeLast((List)target.getChildren());
            }
            catch (Exception e) {
                log.info("warning during encoding", (Throwable)e);
            }
        }
        return target;
    }

    @Override
    public Object decode(TDNode tdNode, Type type, Object targetObj, BeanCoderContext ctx) {
        Class<?> cls = ClassUtil.getGenericClass((Type)type);
        if (tdNode.getType() != TDNode.Type.MAP) {
            if (tdNode.getValue() != null && cls.isAssignableFrom(tdNode.getValue().getClass())) {
                return tdNode.getValue();
            }
            if (cls.isAssignableFrom(TDNode.class)) {
                return tdNode;
            }
            throw new BeanCoderException("Expect an Map object, but actual type=" + tdNode.getType() + ";o=" + StringUtil.toTrimmedStr((Object)(TDJSONWriter.get().writeAsString(tdNode) + ": pos=" + tdNode.getStart()), (int)500));
        }
        Object subType = tdNode.getChildValue(TYPE_KEY);
        if (subType instanceof String) {
            try {
                cls = Class.forName((String)subType);
            }
            catch (ClassNotFoundException e) {
                throw new BeanCoderException("Incorrect $type:" + subType, e);
            }
        }
        if (cls.isAssignableFrom(TDNode.class)) {
            return tdNode;
        }
        Object result = targetObj;
        if (result == null) {
            Constructor<?> cstr = cls.getDeclaredConstructor(new Class[0]);
            cstr.setAccessible(true);
            result = cstr.newInstance(new Object[0]);
        }
        ctx.getNodeToObjectMap().put(tdNode, result);
        Map pds = ClassUtil.getProperties(cls);
        JSONCoderOption opt = ctx.getOption();
        if (tdNode.getChildren() == null) {
            return result;
        }
        for (TDNode nc : tdNode.getChildren()) {
            BeanProperty prop = (BeanProperty)pds.get(nc.getKey());
            if (prop == null) {
                prop = (BeanProperty)pds.get(StringUtil.lowerFirst((String)nc.getKey()));
            }
            if (prop == null) {
                if (!opt.isErrorOnUnknownProperty()) continue;
                throw new BeanCoderException("No such attribute:" + nc.getKey() + ",class:" + cls);
            }
            int mod = prop.getModifier();
            if (Modifier.isStatic(mod) || prop.isTransient()) {
                if (!opt.isErrorOnUnknownProperty()) continue;
                throw new BeanCoderException("Field is static or transient:" + nc.getKey() + ",class:" + cls);
            }
            Object childTargetObj = null;
            if (prop.isReadable(true) && !ClassUtil.isSimpleType((Class)prop.getType()) && !Enum.class.isAssignableFrom(prop.getType()) && !Date.class.isAssignableFrom(prop.getType())) {
                try {
                    childTargetObj = prop.get(result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (childTargetObj == null && prop.isImmutable(true)) {
                if (!opt.isErrorOnUnknownProperty()) continue;
                throw new BeanCoderException("Field is not mutable:" + nc.getKey() + ",class:" + cls);
            }
            Type childType = prop.getGenericType();
            Object child = ctx.decode(nc, childType, childTargetObj, nc.getKey());
            if (childTargetObj == child) continue;
            prop.set(result, child);
        }
        return result;
    }
}

