/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.core.factory.InjectableInstance;
import com.jsonex.core.util.ClassUtil;
import com.jsonex.core.util.StringUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.BeanCoderException;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.jsoncoder.JSONCoderOption;
import com.jsonex.jsoncoder.coder.CoderArray;
import com.jsonex.jsoncoder.coder.CoderCollection;
import com.jsonex.jsoncoder.coder.CoderMap;
import com.jsonex.jsoncoder.coder.CoderObject;
import com.jsonex.treedoc.TDNode;
import com.jsonex.treedoc.TreeDoc;
import com.jsonex.treedoc.json.TDJSONWriter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class BeanCoder {
    public static final InjectableInstance<BeanCoder> it = InjectableInstance.of(BeanCoder.class);
    private static final int MAX_OBJECTS = 10000;
    private static final int MAX_DEPTH = 50;
    public static final String ID_KEY = "$id";
    private static final String REF_KEY = "$ref";

    public static BeanCoder get() {
        return (BeanCoder)it.get();
    }

    public TDNode encode(Object obj) {
        return this.encode(obj, new BeanCoderContext(JSONCoderOption.global), null);
    }

    public TDNode encode(Object obj, BeanCoderContext context, Type type) {
        return this._encode(obj, context.reset(), type, new TreeDoc().getRoot());
    }

    public Object decode(TDNode obj, Type type) {
        return this.decode(obj, type, null, "", new BeanCoderContext(JSONCoderOption.global));
    }

    public <T> T decode(TDNode obj, T target) {
        return (T)this.decode(obj, target.getClass(), target, "", new BeanCoderContext(JSONCoderOption.global));
    }

    public <T> T deepClone(T src) {
        return (T)(src == null ? null : this.decode(this.encode(src), src.getClass()));
    }

    public <T> T deepCopyTo(T src, T target) {
        return src == null ? null : (T)this.decode(this.encode(src), target);
    }

    TDNode _encode(Object obj, BeanCoderContext ctx, Type type, TDNode target) {
        JSONCoderOption opt = ctx.getOption();
        int pathSize = ctx.objectPath.size();
        try {
            if (obj == null) {
                TDNode tDNode = target;
                return tDNode;
            }
            Class<?> cls = obj.getClass();
            if (obj.getClass().getName().startsWith("java.lang.reflect.") || cls == Object.class || cls == BigDecimal.class) {
                TDNode tDNode = target.setValue((Object)obj.toString());
                return tDNode;
            }
            if (ClassUtil.isSimpleType(cls)) {
                TDNode tDNode = target.setValue(obj);
                return tDNode;
            }
            if (opt.isClassSkipped(cls)) {
                TDNode tDNode = target;
                return tDNode;
            }
            ICoder<?> coder = opt.findCoder(cls);
            if (coder != null) {
                TDNode tDNode = coder.encode(obj, type, ctx, target);
                return tDNode;
            }
            Object eqWrapper = opt.getEqualsWrapper(obj);
            try {
                int p = ctx.objectPath.indexOf(eqWrapper);
                if (p >= 0) {
                    TDNode tDNode = BeanCoder.setRef(target, StringUtil.appendRepeatedly((StringBuilder)new StringBuilder(), (String)"../", (int)(p + 1)).toString());
                    return tDNode;
                }
            }
            catch (ClassCastException p) {
                // empty catch block
            }
            if (ctx.objToNodeMap.size() > 10000 || ctx.objectPath.size() > 50) {
                TDNode p = target.setValue((Object)"[TRIMMED_DUE_TO_TOO_MANY_OBJECT]");
                return p;
            }
            TDNode orgResult = ctx.objToNodeMap.get(eqWrapper);
            if (opt.dedupWithRef && orgResult != null) {
                if (orgResult.getType() == TDNode.Type.MAP) {
                    Integer id = (Integer)orgResult.getChildValue(ID_KEY);
                    if (id == null) {
                        id = ctx.getNextId();
                        orgResult.createChild(ID_KEY).setValue((Object)id);
                    }
                    TDNode tDNode = BeanCoder.setRef(target, "#" + id);
                    return tDNode;
                }
                TDNode tDNode = BeanCoder.setRef(target, orgResult.getPathAsString());
                return tDNode;
            }
            if (!(obj instanceof Collection && ((Collection)obj).isEmpty() || obj instanceof Map && ((Map)obj).isEmpty())) {
                ctx.objectPath.push(eqWrapper);
            }
            if (cls.isArray()) {
                CoderArray.get().encode(obj, type, ctx, target);
            } else if (obj instanceof Collection) {
                CoderCollection.get().encode((Collection)obj, type, ctx, target);
            } else if (obj instanceof Map) {
                CoderMap.get().encode((Map)obj, type, ctx, target);
            } else {
                CoderObject.get().encode(obj, type, ctx, target);
            }
            if (target.getType() == TDNode.Type.MAP || target.getType() == TDNode.Type.ARRAY) {
                ctx.objToNodeMap.put(eqWrapper, target);
            }
            TDNode tDNode = target;
            return tDNode;
        }
        catch (Exception ex) {
            throw new BeanCoderException(ex);
        }
        finally {
            if (ctx.objectPath.size() > pathSize) {
                ctx.objectPath.pop();
            }
        }
    }

    private static TDNode setRef(TDNode node, String ref) {
        node.setType(TDNode.Type.MAP).createChild(REF_KEY).setValue((Object)ref);
        return node;
    }

    public Object decode(TDNode tdNode, Type type, Object targetObj, String name, BeanCoderContext ctx) {
        if (tdNode == null) {
            return null;
        }
        Class cls = ClassUtil.getGenericClass((Type)type);
        try {
            Object result;
            Object refVal = tdNode.getChildValue(REF_KEY);
            if (refVal instanceof String) {
                String ref = (String)refVal;
                TDNode target = tdNode.getByPath(ref);
                if (target == null) {
                    throw new BeanCoderException("Reference is not found: ref:" + ref + "; current Node:" + tdNode.getPathAsString());
                }
                return ctx.nodeToObjectMap.get(target);
            }
            if (tdNode.getType() == TDNode.Type.SIMPLE && (result = ClassUtil.objectToSimpleType((Object)tdNode.getValue(), (Class)cls)) != null) {
                return result;
            }
            ICoder<?> coder = ctx.option.findCoder(cls);
            if (coder != null) {
                return coder.decode(tdNode, type, targetObj, ctx);
            }
            if (cls == String.class) {
                return TDJSONWriter.get().writeAsString(tdNode);
            }
            if (cls.isArray()) {
                return CoderArray.get().decode(tdNode, type, targetObj, ctx);
            }
            if (Collection.class.isAssignableFrom(cls)) {
                return CoderCollection.get().decode(tdNode, type, targetObj, ctx);
            }
            if (Map.class.isAssignableFrom(cls)) {
                return CoderMap.get().decode(tdNode, type, targetObj, ctx);
            }
            return CoderObject.get().decode(tdNode, type, targetObj, ctx);
        }
        catch (Exception e) {
            throw new BeanCoderException("failed to decode:" + type + "; name=" + name, e);
        }
    }

    private static int abs(int a) {
        return a < 0 ? -a : a;
    }
}

