/*
 * Decompiled with CFR 0.152.
 */
package com.jsonex.jsoncoder;

import com.jsonex.core.type.Tuple;
import com.jsonex.core.util.BeanProperty;
import com.jsonex.core.util.LangUtil;
import com.jsonex.jsoncoder.BeanCoderContext;
import com.jsonex.jsoncoder.EqualsWrapper;
import com.jsonex.jsoncoder.FieldTransformer;
import com.jsonex.jsoncoder.ICoder;
import com.jsonex.jsoncoder.SimpleFilter;
import com.jsonex.jsoncoder.coder.CoderAtomicInteger;
import com.jsonex.jsoncoder.coder.CoderBigInteger;
import com.jsonex.jsoncoder.coder.CoderClass;
import com.jsonex.jsoncoder.coder.CoderDate;
import com.jsonex.jsoncoder.coder.CoderEnum;
import com.jsonex.jsoncoder.coder.CoderXMLGregorianCalendar;
import com.jsonex.treedoc.json.TDJSONOption;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;

public class JSONCoderOption {
    static final JSONCoderOption global = new JSONCoderOption(null);
    private final JSONCoderOption parent;
    boolean ignoreReadOnly;
    Boolean ignoreSubClassFields;
    boolean showEnumName;
    boolean showType;
    boolean dedupWithRef;
    boolean showPrivateField;
    String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private final List<String> fallbackDateFormats = new ArrayList<String>();
    boolean alwaysMapKeyAsString;
    boolean errorOnUnknownProperty;
    private final Set<Class<?>> skippedClasses = new HashSet();
    private final Set<Class<?>> ignoreSubClassFieldsClasses = new HashSet();
    private final List<Tuple.Pair<Class<?>, FieldTransformer>> filters = new ArrayList();
    private final List<ICoder<?>> coderList = new ArrayList();
    private final List<EqualsWrapper<?>> equalsWrapper = new ArrayList();
    private TDJSONOption jsonOption = new TDJSONOption();
    private LogLevel warnLogLevel = LogLevel.INFO;
    private boolean allowPolymorphicClasses = false;

    public JSONCoderOption() {
        this(global);
    }

    private JSONCoderOption(JSONCoderOption parent) {
        this.parent = parent;
    }

    public static JSONCoderOption of() {
        return new JSONCoderOption();
    }

    public static JSONCoderOption withIndentFactor(int factor) {
        return new JSONCoderOption().setJsonOption(TDJSONOption.withIndentFactor((int)factor));
    }

    ICoder<?> findCoder(Class<?> cls) {
        for (ICoder<?> bc : this.coderList) {
            if (!bc.getType().isAssignableFrom(cls)) continue;
            return bc;
        }
        return this.parent == null ? null : this.parent.findCoder(cls);
    }

    public boolean isClassSkipped(Class<?> cls) {
        for (Class<?> skip : this.skippedClasses) {
            if (!skip.isAssignableFrom(cls)) continue;
            return true;
        }
        return this.parent != null && this.parent.isClassSkipped(cls);
    }

    public FieldTransformer.FieldInfo transformField(Class<?> cls, Object o, BeanProperty property, BeanCoderContext beanCoderContext) {
        for (Tuple.Pair<Class<?>, FieldTransformer> filter : this.filters) {
            FieldTransformer.FieldInfo fieldInfo;
            if (!((Class)filter._1).isAssignableFrom(cls) || (fieldInfo = ((FieldTransformer)filter._2).apply(o, property, beanCoderContext)) == null) continue;
            return fieldInfo;
        }
        return this.parent == null ? null : this.parent.transformField(cls, o, property, beanCoderContext);
    }

    Object getEqualsWrapper(Object obj) {
        for (EqualsWrapper<?> ew : this.equalsWrapper) {
            if (!ew.getType().isAssignableFrom(obj.getClass())) continue;
            return ew.newWrapper(obj);
        }
        return this.parent == null ? obj : this.parent.getEqualsWrapper(obj);
    }

    public Date parseDateFullback(String dateStr) throws ParseException {
        ParseException exp = null;
        for (String fmt : this.fallbackDateFormats) {
            try {
                return new SimpleDateFormat(fmt).parse(dateStr);
            }
            catch (ParseException e1) {
                exp = e1;
            }
        }
        if (this.parent == null) {
            throw exp == null ? new ParseException(dateStr, 0) : exp;
        }
        return this.parent.parseDateFullback(dateStr);
    }

    public boolean isIgnoreSubClassFields(Class<?> cls) {
        if (this.ignoreSubClassFields == Boolean.TRUE) {
            return true;
        }
        for (Class<?> iCls : this.ignoreSubClassFieldsClasses) {
            if (!iCls.isAssignableFrom(cls)) continue;
            return true;
        }
        return this.parent != null && this.parent.isIgnoreSubClassFields(cls);
    }

    public SimpleFilter getDefaultFilter() {
        return this.getSimpleFilterFor(Object.class);
    }

    public SimpleFilter getSimpleFilterFor(Class<?> cls) {
        for (Tuple.Pair<Class<?>, FieldTransformer> filter : this.filters) {
            if (!(filter._2 instanceof SimpleFilter) || filter._1 != cls) continue;
            return (SimpleFilter)filter._2;
        }
        SimpleFilter result = SimpleFilter.of();
        this.filters.add(0, Tuple.of(cls, (Object)result));
        return result;
    }

    public JSONCoderOption addFilterFor(Class<?> cls, FieldTransformer filter) {
        return this.addFilterFor(cls, filter, false);
    }

    public JSONCoderOption addFilterFor(Class<?> cls, FieldTransformer filter, boolean last) {
        Tuple.Pair clsToFilter = Tuple.of(cls, (Object)filter);
        LangUtil.doIfElse((boolean)last, () -> this.filters.add(clsToFilter), () -> this.filters.add(0, clsToFilter));
        return this;
    }

    public JSONCoderOption addSkippedClasses(Class<?> ... cls) {
        this.skippedClasses.addAll(Arrays.asList(cls));
        return this;
    }

    public JSONCoderOption addIgnoreSubClassFieldsClasses(Class<?> ... cls) {
        Collections.addAll(this.ignoreSubClassFieldsClasses, cls);
        return this;
    }

    public JSONCoderOption addCoder(ICoder<?> ... codes) {
        this.coderList.addAll(Arrays.asList(codes));
        return this;
    }

    public JSONCoderOption setJsonOption(boolean alwaysQuoteName, char quoteChar, int indentFactor) {
        this.jsonOption.setAlwaysQuoteName(alwaysQuoteName).setQuoteChar(quoteChar).setIndentFactor(indentFactor);
        return this;
    }

    @Generated
    public static JSONCoderOption getGlobal() {
        return global;
    }

    @Generated
    public boolean isIgnoreReadOnly() {
        return this.ignoreReadOnly;
    }

    @Generated
    public JSONCoderOption setIgnoreReadOnly(boolean ignoreReadOnly) {
        this.ignoreReadOnly = ignoreReadOnly;
        return this;
    }

    @Generated
    public Boolean getIgnoreSubClassFields() {
        return this.ignoreSubClassFields;
    }

    @Generated
    public JSONCoderOption setIgnoreSubClassFields(Boolean ignoreSubClassFields) {
        this.ignoreSubClassFields = ignoreSubClassFields;
        return this;
    }

    @Generated
    public boolean isShowEnumName() {
        return this.showEnumName;
    }

    @Generated
    public JSONCoderOption setShowEnumName(boolean showEnumName) {
        this.showEnumName = showEnumName;
        return this;
    }

    @Generated
    public boolean isShowType() {
        return this.showType;
    }

    @Generated
    public JSONCoderOption setShowType(boolean showType) {
        this.showType = showType;
        return this;
    }

    @Generated
    public boolean isDedupWithRef() {
        return this.dedupWithRef;
    }

    @Generated
    public JSONCoderOption setDedupWithRef(boolean dedupWithRef) {
        this.dedupWithRef = dedupWithRef;
        return this;
    }

    @Generated
    public boolean isShowPrivateField() {
        return this.showPrivateField;
    }

    @Generated
    public JSONCoderOption setShowPrivateField(boolean showPrivateField) {
        this.showPrivateField = showPrivateField;
        return this;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public JSONCoderOption setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Generated
    public List<String> getFallbackDateFormats() {
        return this.fallbackDateFormats;
    }

    @Generated
    public boolean isAlwaysMapKeyAsString() {
        return this.alwaysMapKeyAsString;
    }

    @Generated
    public JSONCoderOption setAlwaysMapKeyAsString(boolean alwaysMapKeyAsString) {
        this.alwaysMapKeyAsString = alwaysMapKeyAsString;
        return this;
    }

    @Generated
    public boolean isErrorOnUnknownProperty() {
        return this.errorOnUnknownProperty;
    }

    @Generated
    public JSONCoderOption setErrorOnUnknownProperty(boolean errorOnUnknownProperty) {
        this.errorOnUnknownProperty = errorOnUnknownProperty;
        return this;
    }

    @Generated
    public Set<Class<?>> getSkippedClasses() {
        return this.skippedClasses;
    }

    @Generated
    public Set<Class<?>> getIgnoreSubClassFieldsClasses() {
        return this.ignoreSubClassFieldsClasses;
    }

    @Generated
    public List<Tuple.Pair<Class<?>, FieldTransformer>> getFilters() {
        return this.filters;
    }

    @Generated
    public List<ICoder<?>> getCoderList() {
        return this.coderList;
    }

    @Generated
    public List<EqualsWrapper<?>> getEqualsWrapper() {
        return this.equalsWrapper;
    }

    @Generated
    public TDJSONOption getJsonOption() {
        return this.jsonOption;
    }

    @Generated
    public JSONCoderOption setJsonOption(TDJSONOption jsonOption) {
        this.jsonOption = jsonOption;
        return this;
    }

    @Generated
    public LogLevel getWarnLogLevel() {
        return this.warnLogLevel;
    }

    @Generated
    public JSONCoderOption setWarnLogLevel(LogLevel warnLogLevel) {
        this.warnLogLevel = warnLogLevel;
        return this;
    }

    @Generated
    public boolean isAllowPolymorphicClasses() {
        return this.allowPolymorphicClasses;
    }

    @Generated
    public JSONCoderOption setAllowPolymorphicClasses(boolean allowPolymorphicClasses) {
        this.allowPolymorphicClasses = allowPolymorphicClasses;
        return this;
    }

    static {
        JSONCoderOption.global.coderList.add(new CoderDate());
        JSONCoderOption.global.coderList.add(new CoderEnum());
        JSONCoderOption.global.coderList.add(new CoderXMLGregorianCalendar());
        JSONCoderOption.global.coderList.add(new CoderAtomicInteger());
        JSONCoderOption.global.coderList.add(new CoderBigInteger());
        JSONCoderOption.global.coderList.add(new CoderClass());
        JSONCoderOption.global.skippedClasses.add(Format.class);
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd HH:mm:ss.SSS.Z");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy/MM/dd HH:mm:ss.SSS.Z");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd HH:mm:ss.SSS");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd HH:mm:ss");
        JSONCoderOption.global.fallbackDateFormats.add("yyyy-MM-dd");
        JSONCoderOption.global.fallbackDateFormats.add("HH:mm:ss");
        global.getDefaultFilter().addProperties("copy");
    }

    public static enum LogLevel {
        OFF{

            @Override
            public void log(Logger log, String msg, Exception e) {
            }
        }
        ,
        DEBUG{

            @Override
            public void log(Logger log, String msg, Exception e) {
                log.debug(msg, (Throwable)e);
            }
        }
        ,
        INFO{

            @Override
            public void log(Logger log, String msg, Exception e) {
                log.info(msg, (Throwable)e);
            }
        }
        ,
        WARN{

            @Override
            public void log(Logger log, String msg, Exception e) {
                log.warn(msg, (Throwable)e);
            }
        }
        ,
        ERROR{

            @Override
            public void log(Logger log, String msg, Exception e) {
                log.error(msg, (Throwable)e);
            }
        };


        public abstract void log(Logger var1, String var2, Exception var3);
    }
}

