/*
 * Decompiled with CFR 0.152.
 */
package com.labstack;

import com.labstack.Logging;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class Client {
    private OkHttpClient okHttp;
    private String appId;
    private String appName;
    public static final String API_URL = "https://api.labstack.com";
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public Client(final String apiKey) {
        this.okHttp = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request compressedRequest = chain.request().newBuilder().header("Authorization", "Bearer " + apiKey).build();
                return chain.proceed(compressedRequest);
            }
        }).build();
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Logging Logging() {
        Logging logging = new Logging();
        logging.setOkHttp(this.okHttp);
        logging.setAppId(this.appId);
        logging.setAppName(this.appName);
        logging.setLevel("INFO");
        logging.setBatchSize(60);
        logging.setDispatchInterval(60);
        return logging;
    }
}

