/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.LDValueTypeAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@JsonAdapter(value=LDValueTypeAdapter.class)
final class LDValueArray
extends LDValue {
    private static final LDValueArray EMPTY = new LDValueArray(Collections.emptyList());
    private final List<LDValue> list;

    static LDValueArray fromList(List<LDValue> list) {
        return list.isEmpty() ? EMPTY : new LDValueArray(list);
    }

    private LDValueArray(List<LDValue> list) {
        this.list = Collections.unmodifiableList(list);
    }

    @Override
    public LDValueType getType() {
        return LDValueType.ARRAY;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterable<LDValue> values() {
        return this.list;
    }

    @Override
    public LDValue get(int index) {
        if (index >= 0 && index < this.list.size()) {
            return this.list.get(index);
        }
        return LDValueArray.ofNull();
    }

    @Override
    void write(JsonWriter writer) throws IOException {
        writer.beginArray();
        for (LDValue v : this.list) {
            v.write(writer);
        }
        writer.endArray();
    }
}

