/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.launchdarkly.sdk.server.Loggers;
import com.launchdarkly.sdk.server.PersistentDataStoreStatusManager;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.interfaces.DataStore;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.DataStoreUpdates;
import com.launchdarkly.sdk.server.interfaces.PersistentDataStore;
import java.io.IOException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

final class PersistentDataStoreWrapper
implements DataStore {
    private static final Logger logger = Loggers.DATA_STORE;
    private final PersistentDataStore core;
    private final LoadingCache<CacheKey, Optional<DataStoreTypes.ItemDescriptor>> itemCache;
    private final LoadingCache<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> allCache;
    private final LoadingCache<String, Boolean> initCache;
    private final PersistentDataStoreStatusManager statusManager;
    private final boolean cacheIndefinitely;
    private final Set<DataStoreTypes.DataKind> cachedDataKinds = new HashSet<DataStoreTypes.DataKind>();
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final ListeningExecutorService cacheExecutor;

    PersistentDataStoreWrapper(final PersistentDataStore core, Duration cacheTtl, PersistentDataStoreBuilder.StaleValuesPolicy staleValuesPolicy, boolean recordCacheStats, DataStoreUpdates dataStoreUpdates, ScheduledExecutorService sharedExecutor) {
        this.core = core;
        if (cacheTtl.isZero()) {
            this.itemCache = null;
            this.allCache = null;
            this.initCache = null;
            this.cacheExecutor = null;
            this.cacheIndefinitely = false;
        } else {
            this.cacheIndefinitely = cacheTtl.isNegative();
            CacheLoader<CacheKey, Optional<DataStoreTypes.ItemDescriptor>> itemLoader = new CacheLoader<CacheKey, Optional<DataStoreTypes.ItemDescriptor>>(){

                public Optional<DataStoreTypes.ItemDescriptor> load(CacheKey key) throws Exception {
                    return Optional.fromNullable((Object)PersistentDataStoreWrapper.this.getAndDeserializeItem(key.kind, key.key));
                }
            };
            CacheLoader<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> allLoader = new CacheLoader<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>(){

                public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> load(DataStoreTypes.DataKind kind) throws Exception {
                    return PersistentDataStoreWrapper.this.getAllAndDeserialize(kind);
                }
            };
            CacheLoader<String, Boolean> initLoader = new CacheLoader<String, Boolean>(){

                public Boolean load(String key) throws Exception {
                    return core.isInitialized();
                }
            };
            if (staleValuesPolicy == PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH_ASYNC) {
                this.cacheExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)sharedExecutor);
                itemLoader = CacheLoader.asyncReloading((CacheLoader)itemLoader, (Executor)this.cacheExecutor);
            } else {
                this.cacheExecutor = null;
            }
            this.itemCache = PersistentDataStoreWrapper.newCacheBuilder(cacheTtl, staleValuesPolicy, recordCacheStats).build((CacheLoader)itemLoader);
            this.allCache = PersistentDataStoreWrapper.newCacheBuilder(cacheTtl, staleValuesPolicy, recordCacheStats).build((CacheLoader)allLoader);
            this.initCache = PersistentDataStoreWrapper.newCacheBuilder(cacheTtl, staleValuesPolicy, recordCacheStats).build((CacheLoader)initLoader);
        }
        this.statusManager = new PersistentDataStoreStatusManager(!this.cacheIndefinitely, true, this::pollAvailabilityAfterOutage, dataStoreUpdates::updateStatus, sharedExecutor);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(Duration cacheTtl, PersistentDataStoreBuilder.StaleValuesPolicy staleValuesPolicy, boolean recordCacheStats) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        boolean isInfiniteTtl = cacheTtl.isNegative();
        if (!isInfiniteTtl) {
            builder = staleValuesPolicy == PersistentDataStoreBuilder.StaleValuesPolicy.EVICT ? builder.expireAfterWrite(cacheTtl) : builder.refreshAfterWrite(cacheTtl);
        }
        if (recordCacheStats) {
            builder = builder.recordStats();
        }
        return builder;
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    @Override
    public boolean isInitialized() {
        boolean result;
        if (this.inited.get()) {
            return true;
        }
        try {
            result = this.initCache != null ? ((Boolean)this.initCache.get((Object)"")).booleanValue() : this.core.isInitialized();
        }
        catch (Exception e) {
            result = false;
        }
        if (result) {
            this.inited.set(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        Set<DataStoreTypes.DataKind> set = this.cachedDataKinds;
        synchronized (set) {
            this.cachedDataKinds.clear();
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e : allData.getData()) {
                this.cachedDataKinds.add(e.getKey());
            }
        }
        ImmutableList.Builder allBuilder = ImmutableList.builder();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e0 : allData.getData()) {
            DataStoreTypes.DataKind kind = e0.getKey();
            DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> items = this.serializeAll(kind, e0.getValue());
            allBuilder.add(new AbstractMap.SimpleEntry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>>(kind, items));
        }
        RuntimeException failure = this.initCore(new DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor>((Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>>>)allBuilder.build()));
        if (this.itemCache != null && this.allCache != null) {
            this.itemCache.invalidateAll();
            this.allCache.invalidateAll();
            if (failure != null && !this.cacheIndefinitely) {
                throw failure;
            }
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e0 : allData.getData()) {
                DataStoreTypes.DataKind kind = e0.getKey();
                DataStoreTypes.KeyedItems immutableItems = new DataStoreTypes.KeyedItems(ImmutableList.copyOf(e0.getValue().getItems()));
                this.allCache.put((Object)kind, immutableItems);
                for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e1 : e0.getValue().getItems()) {
                    this.itemCache.put((Object)CacheKey.forItem(kind, e1.getKey()), (Object)Optional.of((Object)e1.getValue()));
                }
            }
        }
        if (failure == null || this.cacheIndefinitely) {
            this.inited.set(true);
        }
        if (failure != null) {
            throw failure;
        }
    }

    private RuntimeException initCore(DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> allData) {
        try {
            this.core.init(allData);
            this.processError(null);
            return null;
        }
        catch (RuntimeException e) {
            this.processError(e);
            return e;
        }
    }

    @Override
    public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        try {
            DataStoreTypes.ItemDescriptor ret = this.itemCache != null ? (DataStoreTypes.ItemDescriptor)((Optional)this.itemCache.get((Object)CacheKey.forItem(kind, key))).orNull() : this.getAndDeserializeItem(kind, key);
            this.processError(null);
            return ret;
        }
        catch (Exception e) {
            this.processError(e);
            throw PersistentDataStoreWrapper.getAsRuntimeException(e);
        }
    }

    @Override
    public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        try {
            DataStoreTypes.KeyedItems ret = this.allCache != null ? (DataStoreTypes.KeyedItems)this.allCache.get((Object)kind) : this.getAllAndDeserialize(kind);
            this.processError(null);
            return ret;
        }
        catch (Exception e) {
            this.processError(e);
            throw PersistentDataStoreWrapper.getAsRuntimeException(e);
        }
    }

    private static RuntimeException getAsRuntimeException(Exception e) {
        Throwable t = e instanceof ExecutionException || e instanceof UncheckedExecutionException ? e.getCause() : e;
        return t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        Set<DataStoreTypes.DataKind> set = this.cachedDataKinds;
        synchronized (set) {
            this.cachedDataKinds.add(kind);
        }
        DataStoreTypes.SerializedItemDescriptor serializedItem = this.serialize(kind, item);
        boolean updated = false;
        RuntimeException failure = null;
        try {
            updated = this.core.upsert(kind, key, serializedItem);
            this.processError(null);
        }
        catch (RuntimeException e) {
            this.processError(e);
            if (!this.cacheIndefinitely) {
                throw e;
            }
            failure = e;
        }
        if (this.itemCache != null) {
            CacheKey cacheKey = CacheKey.forItem(kind, key);
            if (failure == null) {
                if (updated) {
                    this.itemCache.put((Object)cacheKey, (Object)Optional.of((Object)item));
                } else {
                    this.itemCache.refresh((Object)cacheKey);
                }
            } else {
                Optional oldItem = (Optional)this.itemCache.getIfPresent((Object)cacheKey);
                if (oldItem == null || !oldItem.isPresent() || ((DataStoreTypes.ItemDescriptor)oldItem.get()).getVersion() < item.getVersion()) {
                    this.itemCache.put((Object)cacheKey, (Object)Optional.of((Object)item));
                }
            }
        }
        if (this.allCache != null) {
            if (this.cacheIndefinitely) {
                DataStoreTypes.KeyedItems cachedAll = (DataStoreTypes.KeyedItems)this.allCache.getIfPresent((Object)kind);
                this.allCache.put((Object)kind, this.updateSingleItem(cachedAll, key, item));
            } else {
                this.allCache.invalidate((Object)kind);
            }
        }
        if (failure != null) {
            throw failure;
        }
        return updated;
    }

    @Override
    public boolean isStatusMonitoringEnabled() {
        return true;
    }

    @Override
    public DataStoreStatusProvider.CacheStats getCacheStats() {
        if (this.itemCache == null || this.allCache == null) {
            return null;
        }
        CacheStats itemStats = this.itemCache.stats();
        CacheStats allStats = this.allCache.stats();
        return new DataStoreStatusProvider.CacheStats(itemStats.hitCount() + allStats.hitCount(), itemStats.missCount() + allStats.missCount(), itemStats.loadSuccessCount() + allStats.loadSuccessCount(), itemStats.loadExceptionCount() + allStats.loadExceptionCount(), itemStats.totalLoadTime() + allStats.totalLoadTime(), itemStats.evictionCount() + allStats.evictionCount());
    }

    private DataStoreTypes.ItemDescriptor getAndDeserializeItem(DataStoreTypes.DataKind kind, String key) {
        DataStoreTypes.SerializedItemDescriptor maybeSerializedItem = this.core.get(kind, key);
        return maybeSerializedItem == null ? null : this.deserialize(kind, maybeSerializedItem);
    }

    private DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAllAndDeserialize(DataStoreTypes.DataKind kind) {
        DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> allItems = this.core.getAll(kind);
        if (Iterables.isEmpty(allItems.getItems())) {
            return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(null);
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (Map.Entry<String, DataStoreTypes.SerializedItemDescriptor> e : allItems.getItems()) {
            b.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(e.getKey(), this.deserialize(kind, e.getValue())));
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>((Iterable<Map.Entry<String, DataStoreTypes.ItemDescriptor>>)b.build());
    }

    private DataStoreTypes.SerializedItemDescriptor serialize(DataStoreTypes.DataKind kind, DataStoreTypes.ItemDescriptor itemDesc) {
        boolean isDeleted = itemDesc.getItem() == null;
        return new DataStoreTypes.SerializedItemDescriptor(itemDesc.getVersion(), isDeleted, kind.serialize(itemDesc));
    }

    private DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> serializeAll(DataStoreTypes.DataKind kind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items) {
        ImmutableList.Builder itemsBuilder = ImmutableList.builder();
        for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e : items.getItems()) {
            itemsBuilder.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.SerializedItemDescriptor>(e.getKey(), this.serialize(kind, e.getValue())));
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>((Iterable<Map.Entry<String, DataStoreTypes.SerializedItemDescriptor>>)itemsBuilder.build());
    }

    private DataStoreTypes.ItemDescriptor deserialize(DataStoreTypes.DataKind kind, DataStoreTypes.SerializedItemDescriptor serializedItemDesc) {
        if (serializedItemDesc.isDeleted() || serializedItemDesc.getSerializedItem() == null) {
            return DataStoreTypes.ItemDescriptor.deletedItem(serializedItemDesc.getVersion());
        }
        DataStoreTypes.ItemDescriptor deserializedItem = kind.deserialize(serializedItemDesc.getSerializedItem());
        if (serializedItemDesc.getVersion() == 0 || serializedItemDesc.getVersion() == deserializedItem.getVersion() || deserializedItem.getItem() == null) {
            return deserializedItem;
        }
        return new DataStoreTypes.ItemDescriptor(serializedItemDesc.getVersion(), deserializedItem.getItem());
    }

    private DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> updateSingleItem(DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items, String key, DataStoreTypes.ItemDescriptor item) {
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>((Iterable<Map.Entry<String, DataStoreTypes.ItemDescriptor>>)ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)(items == null ? ImmutableList.of() : Iterables.filter(items.getItems(), e -> !((String)e.getKey()).equals(key))), (Iterable)ImmutableList.of(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(key, item)))));
    }

    private void processError(Throwable error) {
        if (error == null) {
            return;
        }
        this.statusManager.updateAvailability(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollAvailabilityAfterOutage() {
        if (!this.core.isStoreAvailable()) {
            return false;
        }
        if (this.cacheIndefinitely && this.allCache != null) {
            DataStoreTypes.DataKind[] allKinds;
            Set<DataStoreTypes.DataKind> set = this.cachedDataKinds;
            synchronized (set) {
                allKinds = this.cachedDataKinds.toArray(new DataStoreTypes.DataKind[this.cachedDataKinds.size()]);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DataStoreTypes.DataKind kind : allKinds) {
                DataStoreTypes.KeyedItems items = (DataStoreTypes.KeyedItems)this.allCache.getIfPresent((Object)kind);
                if (items == null) continue;
                builder.add(new AbstractMap.SimpleEntry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>>(kind, this.serializeAll(kind, items)));
            }
            RuntimeException e = this.initCore(new DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor>((Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>>>)builder.build()));
            if (e == null) {
                logger.warn("Successfully updated persistent store from cached data");
            } else {
                logger.error("Tried to write cached data to persistent store after a store outage, but failed: {}", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    static final class CacheKey {
        final DataStoreTypes.DataKind kind;
        final String key;

        public static CacheKey forItem(DataStoreTypes.DataKind kind, String key) {
            return new CacheKey(kind, key);
        }

        private CacheKey(DataStoreTypes.DataKind kind, String key) {
            this.kind = kind;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                CacheKey o = (CacheKey)other;
                return o.kind.getName().equals(this.kind.getName()) && o.key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.getName().hashCode() * 31 + this.key.hashCode();
        }
    }
}

