/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.JsonAdapter;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.sdk.server.EvaluatorPreprocessing;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class DataModel {
    public static DataStoreTypes.DataKind FEATURES = new DataStoreTypes.DataKind("features", DataModel::serializeItem, s -> DataModel.deserializeItem(s, FeatureFlag.class));
    public static DataStoreTypes.DataKind SEGMENTS = new DataStoreTypes.DataKind("segments", DataModel::serializeItem, s -> DataModel.deserializeItem(s, Segment.class));
    public static Iterable<DataStoreTypes.DataKind> ALL_DATA_KINDS = ImmutableList.of((Object)FEATURES, (Object)SEGMENTS);

    private DataModel() {
    }

    private static DataStoreTypes.ItemDescriptor deserializeItem(String s, Class<? extends VersionedData> itemClass) {
        VersionedData o = JsonHelpers.deserialize(s, itemClass);
        return o.isDeleted() ? DataStoreTypes.ItemDescriptor.deletedItem(o.getVersion()) : new DataStoreTypes.ItemDescriptor(o.getVersion(), o);
    }

    private static String serializeItem(DataStoreTypes.ItemDescriptor item) {
        Object o = item.getItem();
        if (o != null) {
            return JsonHelpers.serialize(o);
        }
        return "{\"version\":" + item.getVersion() + ",\"deleted\":true}";
    }

    static enum Operator {
        in,
        endsWith,
        startsWith,
        matches,
        contains,
        lessThan,
        lessThanOrEqual,
        greaterThan,
        greaterThanOrEqual,
        before,
        after,
        semVerEqual,
        semVerLessThan,
        semVerGreaterThan,
        segmentMatch;

    }

    static final class SegmentRule {
        private final List<Clause> clauses;
        private final Integer weight;
        private final UserAttribute bucketBy;

        SegmentRule(List<Clause> clauses, Integer weight, UserAttribute bucketBy) {
            this.clauses = clauses;
            this.weight = weight;
            this.bucketBy = bucketBy;
        }

        List<Clause> getClauses() {
            return this.clauses == null ? Collections.emptyList() : this.clauses;
        }

        Integer getWeight() {
            return this.weight;
        }

        UserAttribute getBucketBy() {
            return this.bucketBy;
        }
    }

    @JsonAdapter(value=JsonHelpers.PostProcessingDeserializableTypeAdapterFactory.class)
    static final class Segment
    implements VersionedData,
    JsonHelpers.PostProcessingDeserializable {
        private String key;
        private Set<String> included;
        private Set<String> excluded;
        private String salt;
        private List<SegmentRule> rules;
        private int version;
        private boolean deleted;

        Segment() {
        }

        Segment(String key, Set<String> included, Set<String> excluded, String salt, List<SegmentRule> rules, int version, boolean deleted) {
            this.key = key;
            this.included = included;
            this.excluded = excluded;
            this.salt = salt;
            this.rules = rules;
            this.version = version;
            this.deleted = deleted;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        Collection<String> getIncluded() {
            return this.included == null ? Collections.emptySet() : this.included;
        }

        Collection<String> getExcluded() {
            return this.excluded == null ? Collections.emptySet() : this.excluded;
        }

        String getSalt() {
            return this.salt;
        }

        List<SegmentRule> getRules() {
            return this.rules == null ? Collections.emptyList() : this.rules;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        @Override
        public void afterDeserialized() {
            EvaluatorPreprocessing.preprocessSegment(this);
        }
    }

    static final class WeightedVariation {
        private int variation;
        private int weight;

        WeightedVariation() {
        }

        WeightedVariation(int variation, int weight) {
            this.variation = variation;
            this.weight = weight;
        }

        int getVariation() {
            return this.variation;
        }

        int getWeight() {
            return this.weight;
        }
    }

    static class VariationOrRollout {
        private Integer variation;
        private Rollout rollout;

        VariationOrRollout() {
        }

        VariationOrRollout(Integer variation, Rollout rollout) {
            this.variation = variation;
            this.rollout = rollout;
        }

        Integer getVariation() {
            return this.variation;
        }

        Rollout getRollout() {
            return this.rollout;
        }
    }

    static final class Rollout {
        private List<WeightedVariation> variations;
        private UserAttribute bucketBy;

        Rollout() {
        }

        Rollout(List<WeightedVariation> variations, UserAttribute bucketBy) {
            this.variations = variations;
            this.bucketBy = bucketBy;
        }

        List<WeightedVariation> getVariations() {
            return this.variations == null ? Collections.emptyList() : this.variations;
        }

        UserAttribute getBucketBy() {
            return this.bucketBy;
        }
    }

    static final class Clause {
        private UserAttribute attribute;
        private Operator op;
        private List<LDValue> values;
        private boolean negate;
        transient EvaluatorPreprocessing.ClauseExtra preprocessed;

        Clause() {
        }

        Clause(UserAttribute attribute, Operator op, List<LDValue> values, boolean negate) {
            this.attribute = attribute;
            this.op = op;
            this.values = values;
            this.negate = negate;
        }

        UserAttribute getAttribute() {
            return this.attribute;
        }

        Operator getOp() {
            return this.op;
        }

        List<LDValue> getValues() {
            return this.values == null ? Collections.emptyList() : this.values;
        }

        boolean isNegate() {
            return this.negate;
        }

        EvaluatorPreprocessing.ClauseExtra getPreprocessed() {
            return this.preprocessed;
        }

        void setPreprocessed(EvaluatorPreprocessing.ClauseExtra preprocessed) {
            this.preprocessed = preprocessed;
        }
    }

    static final class Rule
    extends VariationOrRollout {
        private String id;
        private List<Clause> clauses;
        private boolean trackEvents;
        private transient EvaluationReason ruleMatchReason;

        Rule() {
        }

        Rule(String id, List<Clause> clauses, Integer variation, Rollout rollout, boolean trackEvents) {
            super(variation, rollout);
            this.id = id;
            this.clauses = clauses;
            this.trackEvents = trackEvents;
        }

        String getId() {
            return this.id;
        }

        List<Clause> getClauses() {
            return this.clauses == null ? Collections.emptyList() : this.clauses;
        }

        boolean isTrackEvents() {
            return this.trackEvents;
        }

        EvaluationReason getRuleMatchReason() {
            return this.ruleMatchReason;
        }

        void setRuleMatchReason(EvaluationReason ruleMatchReason) {
            this.ruleMatchReason = ruleMatchReason;
        }
    }

    static final class Target {
        private Set<String> values;
        private int variation;

        Target() {
        }

        Target(Set<String> values, int variation) {
            this.values = values;
            this.variation = variation;
        }

        Collection<String> getValues() {
            return this.values == null ? Collections.emptySet() : this.values;
        }

        int getVariation() {
            return this.variation;
        }
    }

    static final class Prerequisite {
        private String key;
        private int variation;
        private transient EvaluationReason prerequisiteFailedReason;

        Prerequisite() {
        }

        Prerequisite(String key, int variation) {
            this.key = key;
            this.variation = variation;
        }

        String getKey() {
            return this.key;
        }

        int getVariation() {
            return this.variation;
        }

        EvaluationReason getPrerequisiteFailedReason() {
            return this.prerequisiteFailedReason;
        }

        void setPrerequisiteFailedReason(EvaluationReason prerequisiteFailedReason) {
            this.prerequisiteFailedReason = prerequisiteFailedReason;
        }
    }

    @JsonAdapter(value=JsonHelpers.PostProcessingDeserializableTypeAdapterFactory.class)
    static final class FeatureFlag
    implements VersionedData,
    JsonHelpers.PostProcessingDeserializable {
        private String key;
        private int version;
        private boolean on;
        private List<Prerequisite> prerequisites;
        private String salt;
        private List<Target> targets;
        private List<Rule> rules;
        private VariationOrRollout fallthrough;
        private Integer offVariation;
        private List<LDValue> variations;
        private boolean clientSide;
        private boolean trackEvents;
        private boolean trackEventsFallthrough;
        private Long debugEventsUntilDate;
        private boolean deleted;

        FeatureFlag() {
        }

        FeatureFlag(String key, int version, boolean on, List<Prerequisite> prerequisites, String salt, List<Target> targets, List<Rule> rules, VariationOrRollout fallthrough, Integer offVariation, List<LDValue> variations, boolean clientSide, boolean trackEvents, boolean trackEventsFallthrough, Long debugEventsUntilDate, boolean deleted) {
            this.key = key;
            this.version = version;
            this.on = on;
            this.prerequisites = prerequisites;
            this.salt = salt;
            this.targets = targets;
            this.rules = rules;
            this.fallthrough = fallthrough;
            this.offVariation = offVariation;
            this.variations = variations;
            this.clientSide = clientSide;
            this.trackEvents = trackEvents;
            this.trackEventsFallthrough = trackEventsFallthrough;
            this.debugEventsUntilDate = debugEventsUntilDate;
            this.deleted = deleted;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        boolean isTrackEvents() {
            return this.trackEvents;
        }

        boolean isTrackEventsFallthrough() {
            return this.trackEventsFallthrough;
        }

        Long getDebugEventsUntilDate() {
            return this.debugEventsUntilDate;
        }

        @Override
        public boolean isDeleted() {
            return this.deleted;
        }

        boolean isOn() {
            return this.on;
        }

        List<Prerequisite> getPrerequisites() {
            return this.prerequisites == null ? Collections.emptyList() : this.prerequisites;
        }

        String getSalt() {
            return this.salt;
        }

        List<Target> getTargets() {
            return this.targets == null ? Collections.emptyList() : this.targets;
        }

        List<Rule> getRules() {
            return this.rules == null ? Collections.emptyList() : this.rules;
        }

        VariationOrRollout getFallthrough() {
            return this.fallthrough;
        }

        List<LDValue> getVariations() {
            return this.variations == null ? Collections.emptyList() : this.variations;
        }

        Integer getOffVariation() {
            return this.offVariation;
        }

        boolean isClientSide() {
            return this.clientSide;
        }

        @Override
        public void afterDeserialized() {
            EvaluatorPreprocessing.preprocessFlag(this);
        }
    }

    static interface VersionedData {
        public String getKey();

        public int getVersion();

        public boolean isDeleted();
    }
}

