/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.JsonHelpers;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAdapter(value=JsonSerialization.class)
public final class FeatureFlagsState
implements JsonSerializable {
    private final Map<String, LDValue> flagValues;
    private final Map<String, FlagMetadata> flagMetadata;
    private final boolean valid;

    private FeatureFlagsState(Map<String, LDValue> flagValues, Map<String, FlagMetadata> flagMetadata, boolean valid) {
        this.flagValues = Collections.unmodifiableMap(flagValues);
        this.flagMetadata = Collections.unmodifiableMap(flagMetadata);
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public LDValue getFlagValue(String key) {
        return this.flagValues.get(key);
    }

    public EvaluationReason getFlagReason(String key) {
        FlagMetadata data = this.flagMetadata.get(key);
        return data == null ? null : data.reason;
    }

    public Map<String, LDValue> toValuesMap() {
        return this.flagValues;
    }

    public boolean equals(Object other) {
        if (other instanceof FeatureFlagsState) {
            FeatureFlagsState o = (FeatureFlagsState)other;
            return this.flagValues.equals(o.flagValues) && this.flagMetadata.equals(o.flagMetadata) && this.valid == o.valid;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.flagValues, this.flagMetadata, this.valid);
    }

    static class JsonSerialization
    extends TypeAdapter<FeatureFlagsState> {
        JsonSerialization() {
        }

        public void write(JsonWriter out, FeatureFlagsState state) throws IOException {
            out.beginObject();
            for (Map.Entry entry : state.flagValues.entrySet()) {
                out.name((String)entry.getKey());
                JsonHelpers.gsonInstance().toJson(entry.getValue(), LDValue.class, out);
            }
            out.name("$flagsState");
            JsonHelpers.gsonInstance().toJson((Object)state.flagMetadata, Map.class, out);
            out.name("$valid");
            out.value(state.valid);
            out.endObject();
        }

        public FeatureFlagsState read(JsonReader in) throws IOException {
            HashMap<String, LDValue> flagValues = new HashMap<String, LDValue>();
            HashMap<String, FlagMetadata> flagMetadata = new HashMap<String, FlagMetadata>();
            boolean valid = true;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("$flagsState")) {
                    in.beginObject();
                    while (in.hasNext()) {
                        String metaName = in.nextName();
                        FlagMetadata meta = (FlagMetadata)JsonHelpers.gsonInstance().fromJson(in, FlagMetadata.class);
                        flagMetadata.put(metaName, meta);
                    }
                    in.endObject();
                    continue;
                }
                if (name.equals("$valid")) {
                    valid = in.nextBoolean();
                    continue;
                }
                LDValue value = (LDValue)JsonHelpers.gsonInstance().fromJson(in, LDValue.class);
                flagValues.put(name, value);
            }
            in.endObject();
            return new FeatureFlagsState(flagValues, flagMetadata, valid);
        }
    }

    static class Builder {
        private Map<String, LDValue> flagValues = new HashMap<String, LDValue>();
        private Map<String, FlagMetadata> flagMetadata = new HashMap<String, FlagMetadata>();
        private final boolean saveReasons;
        private final boolean detailsOnlyForTrackedFlags;
        private boolean valid = true;

        Builder(FlagsStateOption ... options) {
            this.saveReasons = FlagsStateOption.hasOption(options, FlagsStateOption.WITH_REASONS);
            this.detailsOnlyForTrackedFlags = FlagsStateOption.hasOption(options, FlagsStateOption.DETAILS_ONLY_FOR_TRACKED_FLAGS);
        }

        Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        Builder addFlag(DataModel.FeatureFlag flag, Evaluator.EvalResult eval) {
            this.flagValues.put(flag.getKey(), eval.getValue());
            boolean flagIsTracked = flag.isTrackEvents() || flag.getDebugEventsUntilDate() != null && flag.getDebugEventsUntilDate() > System.currentTimeMillis();
            boolean wantDetails = !this.detailsOnlyForTrackedFlags || flagIsTracked;
            FlagMetadata data = new FlagMetadata(eval.isDefault() ? null : Integer.valueOf(eval.getVariationIndex()), this.saveReasons && wantDetails ? eval.getReason() : null, wantDetails ? Integer.valueOf(flag.getVersion()) : null, flag.isTrackEvents(), flag.getDebugEventsUntilDate());
            this.flagMetadata.put(flag.getKey(), data);
            return this;
        }

        FeatureFlagsState build() {
            return new FeatureFlagsState(this.flagValues, this.flagMetadata, this.valid);
        }
    }

    static class FlagMetadata {
        final Integer variation;
        final EvaluationReason reason;
        final Integer version;
        final Boolean trackEvents;
        final Long debugEventsUntilDate;

        FlagMetadata(Integer variation, EvaluationReason reason, Integer version, boolean trackEvents, Long debugEventsUntilDate) {
            this.variation = variation;
            this.reason = reason;
            this.version = version;
            this.trackEvents = trackEvents ? Boolean.TRUE : null;
            this.debugEventsUntilDate = debugEventsUntilDate;
        }

        public boolean equals(Object other) {
            if (other instanceof FlagMetadata) {
                FlagMetadata o = (FlagMetadata)other;
                return Objects.equals(this.variation, o.variation) && Objects.equals(this.reason, o.reason) && Objects.equals(this.version, o.version) && Objects.equals(this.trackEvents, o.trackEvents) && Objects.equals(this.debugEventsUntilDate, o.debugEventsUntilDate);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.variation, this.version, this.trackEvents, this.debugEventsUntilDate);
        }
    }
}

