/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EventUserSerialization;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.SerializationException;
import java.io.IOException;

abstract class JsonHelpers {
    private static final Gson gson = new Gson();

    private JsonHelpers() {
    }

    static Gson gsonInstance() {
        return gson;
    }

    static Gson gsonInstanceForEventsSerialization(EventsConfiguration config) {
        return new GsonBuilder().registerTypeAdapter(LDUser.class, (Object)new EventUserSerialization.UserAdapterWithPrivateAttributeBehavior(config)).create();
    }

    static <T> T deserialize(String json, Class<T> objectClass) throws SerializationException {
        try {
            return (T)gson.fromJson(json, objectClass);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    static String serialize(Object o) {
        return gson.toJson(o);
    }

    static DataModel.VersionedData deserializeFromParsedJson(DataStoreTypes.DataKind kind, JsonElement parsedJson) throws SerializationException {
        DataModel.VersionedData item;
        block4: {
            try {
                if (kind == DataModel.FEATURES) {
                    item = (DataModel.VersionedData)gson.fromJson(parsedJson, DataModel.FeatureFlag.class);
                    break block4;
                }
                if (kind == DataModel.SEGMENTS) {
                    item = (DataModel.VersionedData)gson.fromJson(parsedJson, DataModel.Segment.class);
                    break block4;
                }
                throw new IllegalArgumentException("unknown data kind");
            }
            catch (JsonParseException e) {
                throw new SerializationException(e);
            }
        }
        return item;
    }

    private static class PostProcessingDeserializableTypeAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> baseAdapter;

        PostProcessingDeserializableTypeAdapter(TypeAdapter<T> baseAdapter) {
            this.baseAdapter = baseAdapter;
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.baseAdapter.write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            Object instance = this.baseAdapter.read(in);
            if (instance instanceof PostProcessingDeserializable) {
                ((PostProcessingDeserializable)instance).afterDeserialized();
            }
            return (T)instance;
        }
    }

    static class PostProcessingDeserializableTypeAdapterFactory
    implements TypeAdapterFactory {
        PostProcessingDeserializableTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return new PostProcessingDeserializableTypeAdapter(gson.getDelegateAdapter((TypeAdapterFactory)this, type));
        }
    }

    static interface PostProcessingDeserializable {
        public void afterDeserialized();
    }
}

