/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.internal.events.DiagnosticStore;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ServerSideDiagnosticEvents;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStoreUpdateSink;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

final class ClientContextImpl
extends ClientContext {
    private static volatile ScheduledExecutorService fallbackSharedExecutor = null;
    final ScheduledExecutorService sharedExecutor;
    final DiagnosticStore diagnosticStore;
    final DataSourceUpdateSink dataSourceUpdateSink;
    final DataStoreUpdateSink dataStoreUpdateSink;

    private ClientContextImpl(ClientContext baseContext, ScheduledExecutorService sharedExecutor, DiagnosticStore diagnosticStore) {
        super(baseContext.getSdkKey(), baseContext.getApplicationInfo(), baseContext.getHttp(), baseContext.getLogging(), baseContext.isOffline(), baseContext.getServiceEndpoints(), baseContext.getThreadPriority(), baseContext.getWrapperInfo());
        this.sharedExecutor = sharedExecutor;
        this.diagnosticStore = diagnosticStore;
        this.dataSourceUpdateSink = null;
        this.dataStoreUpdateSink = null;
    }

    private ClientContextImpl(ClientContextImpl copyFrom, DataSourceUpdateSink dataSourceUpdateSink, DataStoreUpdateSink dataStoreUpdateSink) {
        super(copyFrom);
        this.dataSourceUpdateSink = dataSourceUpdateSink;
        this.dataStoreUpdateSink = dataStoreUpdateSink;
        this.diagnosticStore = copyFrom.diagnosticStore;
        this.sharedExecutor = copyFrom.sharedExecutor;
    }

    ClientContextImpl withDataSourceUpdateSink(DataSourceUpdateSink newDataSourceUpdateSink) {
        return new ClientContextImpl(this, newDataSourceUpdateSink, this.dataStoreUpdateSink);
    }

    ClientContextImpl withDataStoreUpdateSink(DataStoreUpdateSink newDataStoreUpdateSink) {
        return new ClientContextImpl(this, this.dataSourceUpdateSink, newDataStoreUpdateSink);
    }

    @Override
    public DataSourceUpdateSink getDataSourceUpdateSink() {
        return this.dataSourceUpdateSink;
    }

    @Override
    public DataStoreUpdateSink getDataStoreUpdateSink() {
        return this.dataStoreUpdateSink;
    }

    static ClientContextImpl fromConfig(String sdkKey, LDConfig config, ScheduledExecutorService sharedExecutor) {
        ClientContext minimalContext = new ClientContext(sdkKey, config.applicationInfo, null, null, config.offline, config.serviceEndpoints, config.threadPriority, config.wrapperInfo);
        LoggingConfiguration loggingConfig = config.logging.build(minimalContext);
        ClientContext contextWithLogging = new ClientContext(sdkKey, config.applicationInfo, null, loggingConfig, config.offline, config.serviceEndpoints, config.threadPriority, config.wrapperInfo);
        HttpConfiguration httpConfig = config.http.build(contextWithLogging);
        if (httpConfig.getProxy() != null) {
            contextWithLogging.getBaseLogger().info("Using proxy: {} {} authentication.", (Object)httpConfig.getProxy(), (Object)(httpConfig.getProxyAuthentication() == null ? "without" : "with"));
        }
        ClientContext contextWithHttpAndLogging = new ClientContext(sdkKey, config.applicationInfo, httpConfig, loggingConfig, config.offline, config.serviceEndpoints, config.threadPriority, config.wrapperInfo);
        DiagnosticStore diagnosticStore = null;
        if (!config.diagnosticOptOut && config.events instanceof EventProcessorBuilder) {
            diagnosticStore = new DiagnosticStore(ServerSideDiagnosticEvents.getSdkDiagnosticParams(contextWithHttpAndLogging, config));
        }
        return new ClientContextImpl(contextWithHttpAndLogging, sharedExecutor, diagnosticStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClientContextImpl get(ClientContext context) {
        if (context instanceof ClientContextImpl) {
            return (ClientContextImpl)context;
        }
        Class<ClientContextImpl> clazz = ClientContextImpl.class;
        synchronized (ClientContextImpl.class) {
            if (fallbackSharedExecutor == null) {
                fallbackSharedExecutor = Executors.newSingleThreadScheduledExecutor();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new ClientContextImpl(context, fallbackSharedExecutor, null);
        }
    }
}

