/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import java.io.IOException;
import java.util.Map;

class InMemoryDataStore
implements DataStore {
    private volatile ImmutableMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> allData = ImmutableMap.of();
    private volatile boolean initialized = false;
    private Object writeLock = new Object();

    InMemoryDataStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        Object object = this.writeLock;
        synchronized (object) {
            ImmutableMap.Builder newData = ImmutableMap.builder();
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> entry : allData.getData()) {
                newData.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue().getItems()));
            }
            this.allData = newData.build();
            this.initialized = true;
        }
    }

    @Override
    public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        Map items = (Map)this.allData.get((Object)kind);
        if (items == null) {
            return null;
        }
        return (DataStoreTypes.ItemDescriptor)items.get(key);
    }

    @Override
    public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        Map items = (Map)this.allData.get((Object)kind);
        if (items == null) {
            return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(null);
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>((Iterable<Map.Entry<String, DataStoreTypes.ItemDescriptor>>)ImmutableList.copyOf(items.entrySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        Object object = this.writeLock;
        synchronized (object) {
            Map existingItems = (Map)this.allData.get((Object)kind);
            DataStoreTypes.ItemDescriptor oldItem = null;
            if (existingItems != null && (oldItem = (DataStoreTypes.ItemDescriptor)existingItems.get(key)) != null && oldItem.getVersion() >= item.getVersion()) {
                return false;
            }
            ImmutableMap.Builder newData = ImmutableMap.builder();
            for (Map.Entry e : this.allData.entrySet()) {
                if (((DataStoreTypes.DataKind)e.getKey()).equals(kind)) continue;
                newData.put((Object)((DataStoreTypes.DataKind)e.getKey()), (Object)((Map)e.getValue()));
            }
            if (existingItems == null) {
                newData.put((Object)kind, (Object)ImmutableMap.of((Object)key, (Object)item));
            } else {
                ImmutableMap.Builder itemsBuilder = ImmutableMap.builder();
                if (oldItem == null) {
                    itemsBuilder.putAll(existingItems);
                } else {
                    for (Map.Entry e : existingItems.entrySet()) {
                        if (((String)e.getKey()).equals(key)) continue;
                        itemsBuilder.put((Object)((String)e.getKey()), (Object)((DataStoreTypes.ItemDescriptor)e.getValue()));
                    }
                }
                itemsBuilder.put((Object)key, (Object)item);
                newData.put((Object)kind, (Object)itemsBuilder.build());
            }
            this.allData = newData.build();
            return true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isStatusMonitoringEnabled() {
        return false;
    }

    @Override
    public DataStoreStatusProvider.CacheStats getCacheStats() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

