/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import java.io.IOException;

abstract class JsonHelpers {
    private static final Gson gsonWithNullsAllowed = new GsonBuilder().serializeNulls().create();
    private static final Gson gsonWithNullsSuppressed = new GsonBuilder().create();

    private JsonHelpers() {
    }

    static Gson gsonInstance() {
        return gsonWithNullsSuppressed;
    }

    static Gson gsonInstanceWithNullsAllowed() {
        return gsonWithNullsAllowed;
    }

    static <T> T deserialize(String json, Class<T> objectClass) throws SerializationException {
        try {
            return (T)JsonHelpers.gsonInstance().fromJson(json, objectClass);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    static <T> T deserialize(JsonReader reader, Class<T> objectClass) throws SerializationException {
        try {
            return (T)JsonHelpers.gsonInstance().fromJson(reader, objectClass);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    static String serialize(Object o) {
        return JsonHelpers.gsonInstance().toJson(o);
    }

    private static class PostProcessingDeserializableTypeAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> baseAdapter;

        PostProcessingDeserializableTypeAdapter(TypeAdapter<T> baseAdapter) {
            this.baseAdapter = baseAdapter;
        }

        public void write(JsonWriter out, T value) throws IOException {
            this.baseAdapter.write(out, value);
        }

        public T read(JsonReader in) throws IOException {
            Object instance = this.baseAdapter.read(in);
            if (instance instanceof PostProcessingDeserializable) {
                ((PostProcessingDeserializable)instance).afterDeserialized();
            }
            return (T)instance;
        }
    }

    static class PostProcessingDeserializableTypeAdapterFactory
    implements TypeAdapterFactory {
        PostProcessingDeserializableTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return new PostProcessingDeserializableTypeAdapter(gson.getDelegateAdapter((TypeAdapterFactory)this, type));
        }
    }

    static interface PostProcessingDeserializable {
        public void afterDeserialized();
    }
}

